<?php

namespace App\Http\Controllers;

use App\Entities\Supplier;
use App\Http\Controllers\Controller;
use App\Http\Resources\Nati\FornecedorResource;
use http\Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use App\Services\SuppliersService;
use App\Http\Requests\SuppliersCreateRequest;
use App\Http\Requests\SuppliersUpdateRequest;
use App\Services\Nati\FichaFornecedorService;

class SuppliersController extends Controller
{
    /**
     * @var SuppliersService
     */
    protected $service;
    protected $fichaService;


    public function __construct(SuppliersService $service, FichaFornecedorService $fichaService)
    {
        $this->service = $service;
        $this->fichaService = $fichaService;
    }

    /**
     * Display a listing of the resource.
     * @param Request $request
     * @return JsonResponse
     */
    public function index(Request $request)
    {
        try {
            return response()->json($this->service->get($request->all()));

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function getAll()
    {
        try {
            $response = Supplier::where('idFornecedor', '>', 0)
                                    ->where('flAtivo', 1)
                                    ->get();
            if ($response) {
                return FornecedorResource::collection($response);
            }
            return response()->json($response);
        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     * @param SuppliersCreateRequest $request
     * @return JsonResponse
     */
    public function store(SuppliersCreateRequest $request)
    {
        try {
            $response = $this->service->insert($request->all());
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }

    /**
     * Show the specified resource.
     * @param $id
     * @return JsonResponse
     */
    public function show($id)
    {
        try {
            $response = $this->service->getById($id);
            return response()->json($response);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }

    /**
     * Update the specified resource in storage.
     * @param SuppliersUpdateRequest $request
     * @param                        $id
     * @return JsonResponse
     */
    public function update(SuppliersUpdateRequest $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json(['data' => $response]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }

    /**
     * Remove the specified resource from storage.
     * @param $id
     * @return JsonResponse
     */
    public function destroy($id)
    {
        try {
            $response = $this->service->delete($id);
            return response()->json($response);

        } catch (\Exception $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }

    public function saveLink(SuppliersCreateRequest $request)
    {
        try {
            return response()->json($this->fichaService->save($request->all()));

        } catch (\Exception $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }

    public function getByCategory($id_category)
    {
        try {
            return response()->json($this->fichaService->getByCategory($id_category));

        } catch (\Exception $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }
    public function count(){
        try {
            return response()->json($this->service->count());
        } catch (Exception $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }

    public function getLinksById($id_supplier)
    {
        try {
            return response()->json($this->fichaService->getLinksById($id_supplier));

        } catch (\Exception $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }

    public function search(Request $request)
    {
        try {
            return response()->json($this->service->search($request));

        } catch (\Exception $e) {

            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }
}
