<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class WsController extends Controller
{
    public function init()
    {
        return $this->handle();
    }
    public function handle()
    {
        $port = config('websockets.port', 6001);
        $serverRunning = $this->isWebSocketServerRunning($port);
        sleep(2);
        if (!$serverRunning) {
            $command = 'php artisan websockets:serve';
            \Illuminate\Support\Facades\Artisan::call('websockets:serve');
        }
        return response()->json(['isRunning' => $serverRunning]);
    }
    private function isWebSocketServerRunning($port)
    {
        $port = config('websockets.port', 6001);
        $output = [];
        exec("netstat -an | find \"LISTEN\" | find \"$port\"", $output);
        return !empty($output);
    }
}
