<?php

namespace App\Http\Resources\Nati;

use Illuminate\Http\Resources\Json\Resource;

class ClosingReportResource extends Resource
{

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request
     * @return array
     */

    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'id_pdv' => $this->id_pdv,
            'operator' => $this->operator,
            'open_date' => $this->open_date,
            'close_date' => $this->close_date,
            'open' => $this->open,
            'change_closing' => (float)$this->change_closing,
            'conference' => $this->conference,
            'note' => $this->note,
            'update_date' => $this->update_date,
            'money_system' => (float)$this->pagamentos()->where('active', true)
                ->where('id_type_payment', 1)->sum('vrFormaPagamento'),
            'card_system' => (float)$this->pagamentos()->where('active', true)
                ->where('id_type_payment', 2)->sum('vrFormaPagamento'),
            //Recebimento de venda convenio
            'sales_covenants' => (float)$this->pagamentos()
                ->whereIn('id_type_payment', [12, 14])
                ->where('active', true)->sum('vrFormaPagamento'),
            //Recebidos de vendas Voucher
            'sales_voucher' => (float)$this->pagamentos()
                ->where('id_type_payment', 20)
                ->where('active', true)->sum('vrFormaPagamento'),
            'discount' => (float)$this->vendas()->where('active', true)
                ->where('delivery', false)->sum('vrDesconto'),
            'total_sales' => $this->totalSales(),
            //Total sem voucher e convenio
            'ref_sales' => (float)$this->refVendas(),
            'money_operator' => (float)$this->detalhes()->where('id_type_payment', 1)->sum('vrPagamento'),
            'card_operator' => (float)$this->detalhes()->where('id_type_payment', 2)->sum('vrPagamento'),
            'voucher' => (float)$this->voucher()->where('active', true)->sum('vrVaucher'),
            'covenants' => (float)$this->cliPagamento()->where('active', true)->sum('vrPagamento'),
            'total_received' => $this->totalReceived(),
            'despesas' => $this->despesas()->where('active', true)->get(),
            'total_despesas' => (float)$this->despesas()->where('active', true)->sum('vrDespesa'),
            'service_table' => (float)$this->vendas()->where('active', true)->sum('vrAcrescimo'),
            'delivery_tax' => (float)$this->vendas()->where('active', true)
                ->where('delivery', true)->sum('vrDesconto'),
            'repique' => (float)$this->repiques()->where('active', true)->sum('vrRepique'),
            'total_services' => $this->totalServices(),
            'open_value' => (float)$this->open_value,
            'sangria' => (float)$this->sangrias()->where('active', true)
                ->where('vrSangria', '>', 0)->sum('vrSangria'),
            'supplies' => (float)$this->sangrias()->where('active', true)
                    ->where('vrSangria', '<', 0)->sum('vrSangria') * -1,
            'difference' => (float)$this->historico()->sum('vrDiferenca'),
            'value_apured' => (float)$this->historico()->sum('vrApurado'),
            //Total de Operações pdv
            'total_operation' => $this->totalOperation(),
        ];
    }

    private function totalSales()
    {
        return (float)$this->pagamentos()->where('active', true)
                ->whereIn('id_type_payment', [1, 2, 4, 6, 12, 14, 20])
                ->sum('vrFormaPagamento') - (float)$this->vendas()
                ->where('active', true)
                ->where('delivery', false)
                ->sum('vrDesconto');
    }

    private function refVendas()
    {
        return (float)$this->pagamentos()->where('active', true)
                ->whereIn('id_type_payment', [1, 2, 4, 6])
                ->sum('vrFormaPagamento') - (float)$this->vendas()
                ->where('active', true)
                ->where('delivery', false)
                ->sum('vrDesconto');
    }

    private function totalReceived()
    {
        return (float)$this->refVendas() + (float)$this->totalServices() +
            (float)$this->voucher()->where('active', true)->sum('vrVaucher') +
            (float)$this->cliPagamento()->where('active', true)->sum('vrPagamento');
    }

    private function totalServices()
    {
        return (float)$this->vendas()->where('active', true)->sum('vrAcrescimo') +
            (float)$this->vendas()->where('active', true)
                ->where('delivery', true)->sum('vrDesconto') +
            (float)$this->repiques()->where('active', true)->sum('vrRepique');
    }

    private function totalOperation()
    {
        return (float)$this->open_value + (float)$this->sangrias()->where('active', true)
                ->where('vrSangria', '<', 0)->sum('vrSangria') * -1 - (float)$this->sangrias()
                ->where('active', true)->where('vrSangria', '>', 0)->sum('vrSangria') -
                (float)$this->despesas()->where('active', true)->sum('vrDespesa');
    }
}


