<?php

namespace App\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Auth\Events\Login;

class InitializeWebSocketOnLogin
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(Login $event)
    {
        $port = config('websockets.port', 6001);
        $serverRunning = $this->isWebSocketServerRunning($port);

        if (!$serverRunning) {
            $command = 'php artisan websockets:serve';
            \Illuminate\Support\Facades\Artisan::call('websockets:serve');
        }
    }
    private function isWebSocketServerRunning($port)
    {
        $port = config('websockets.port', 6001);
        $output = [];
        exec("netstat -an | find \"LISTEN\" | find \"$port\"", $output);
        return !empty($output);
    }
}
