<?php

namespace App\Services;

use App\Entities\Financeiro\Grupo;
use App\Entities\Financeiro\SubGrupo;
use App\Repositories\GrupoRepository;
use App\Validators\GrupoValidator;
use Carbon\Carbon;
use Illuminate\Support\Str;
use Illuminate\Validation\ValidationException;
use Prettus\Validator\Contracts\ValidatorInterface;

class GrupoService
{
    private $repository;
    private $validator;
    private $subGrupo;
    private $conta;

    public function __construct(GrupoRepository $repository, GrupoValidator $validator, SubGrupoService $subGrupo, ContaService $conta)
    {
        $this->validator = $validator;
        $this->repository = $repository;
        $this->subGrupo = $subGrupo;
        $this->conta = $conta;
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
    }

    public function get()
    {
        $grupos = $this->repository->with('subGrupo')->all();

        return $grupos;
    }

    public function getById($id)
    {
        $grupo = $this->repository->with('subGrupo')->find($id);

        return $grupo;
    }

    public function insert($data)
    {
        $categoria = [
            'idCategoriaConta' => $this->nextId(),
            'stCategoriaConta' => $data['stCategoriaConta'],
            'dtAlteracao' => Carbon::now()
        ];
        $this->validator->with($categoria)->passesOrFail(ValidatorInterface::RULE_CREATE);

        $categoriaConta = $this->repository->create($categoria);

        return $categoriaConta;
    }

    public function update($data, $id)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($data, $id);
    }

    public function delete($id)
    {
        $hasSub = SubGrupo::all()->where('idCategoriaConta', $id);

        if (!count($hasSub)) return $this->repository->delete($id);
        else return false;
    }

    public function nextId()
    {
        return Grupo::max('idCategoriaConta') + 1;
    }

    public function addSubgrupo($request, $id)
    {
        if (!isset($request['stTipoConta'])) {
            throw new ValidationException("O Campo SubCategoria é obrigatorio");
        }

        $grupo = $this->repository->find($id);
        $sub = [
            'idTipoConta' => $this->subGrupo->getNextId($grupo->idCategoriaConta),
            'idCategoriaConta' => $grupo->idCategoriaConta,
            'stTipoConta' => Str::upper($request['stTipoConta']),
            'flEntrada' => $request['flEntrada'],
            'idClassificacao' => 1,
            'dtAlteracao' => Carbon::now()->toTimeString()
        ];

        return $grupo->subGrupo()->create($sub);
    }

}
