<?php

namespace App\Services;
use App\Entities\KDSOrder;
use App\Events\NewTabDone;
use App\Events\NewItemDone;

class KDSService
{

    public function __construct()
    {

    }

    public function tabDone($req)
    {
        $orders = KDSOrder::where('idComanda', $req['tabId'])->get();
        foreach ($orders as $order) {
            $order->stStatus = 'Pronto';
            $order->dtData = \Carbon\Carbon::now();
            $order->save();
        }
        event(new NewTabDone($req['tabId']));
        return response()->json([
            'error' => false,
            'message' => 'Tab dispatched successfully'
        ]);
    }
    public function itemDone($req)
    {
        $order = KDSOrder::where('idComanda', $req['tabId'])->where('nrItem', $req['orderItem'])->first();
        $order->stStatus = 'Pronto';
        $order->dtData = \Carbon\Carbon::now();
        $order->save();

        event(new NewItemDone($req));
        return response()->json([
            'error' => false,
            'message' => 'Item dispatched successfully'
        ]);
    }
    public function getAll()
    {
        $orders = KDSOrder::where('flAtivo', true)->where('stStatus', '!=', 'Pronto')->get();
        return response()->json([
            'error' => false,
            'message' => 'Get orders successfully',
            'orders' => $orders
        ], 200);
    }

}
