<?php

namespace App\Services\Nati;

use App\Entities\Nati\FichaFornecedor;
use App\Repositories\Nati\FichaFornecedorRepository;
use App\Services\Service;
use App\Validators\Nati\FichaFornecedorValidator;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Contracts\ValidatorInterface;

class FichaFornecedorService extends Service
{
    protected $repository;
    protected $validator;

    public function __construct(FichaFornecedorRepository $repository, FichaFornecedorValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        return $this->repository->all();
    }

    public function getById($id_supplier, $id_product)
    {
        return $this->repository->findWhere(['id_supplier' => $id_supplier, 'id_product' => $id_product]);
    }

    public function getByProduct($id_product)
    {
        return $this->repository->findWhere(['id_product' => $id_product])->first();
    }

    public function save($request)
    {
        $response = [];

        DB::transaction(function () use ($request, $response) {

            $date = Carbon::now()->toDateTimeString();

            $this->deleteBySupplier($request['id_supplier']);

            foreach ($request['data'] as $item) {

                $data = [
                    'id_supplier' => $request['id_supplier'],
                    'id_product' => $item['id_product'],
                    'id_category' => $item['id_category'],
                    'update_at' => $date,
                ];

                $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);

                $create = $this->repository->create($data);
                array_push($response, collect($create));
            }
        });

        return $response;
    }

    public function saveOne($id_product, $request)
    {
        $data = [
            'id_supplier' => $request['id_supplier'],
            'id_product' => $id_product,
            'id_category' => $request['id_category'],
            'update_at' => $this->getDate(),
        ];

        if($this->getByProduct($id_product)){
            FichaFornecedor::where('id_product', $id_product)->delete();
        }

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return $this->repository->create($data);
    }

    public function getByCategory($id_category)
    {
        return $this->repository->findWhere(['id_category' => $id_category]);
    }

    public function getLinksById($id_supplier)
    {
        return $this->repository->findWhere(['id_supplier' => $id_supplier]);
    }

    public function deleteBySupplier($id_supplier)
    {
        return FichaFornecedor::where('idFornecedor', $id_supplier)->delete();
    }
}
