<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCliExtratoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cli_Extrato')) {
            Schema::create('cli_Extrato', function (Blueprint $table) {
                $table->integer('idExtrato', false, true);
                $table->integer('idAbertura', false,true);
                $table->integer('idFatura', false,true)->default(0);
                $table->integer('idVenda',false,true);
                $table->integer('idOperador', false,true);
                $table->integer('idOperadorAutorizador', false,true);
                $table->integer('idCliente', false,true);
                $table->dateTime('dtData');
                $table->decimal('vrTotal',9, 2);
                $table->decimal('vrDesconto',9, 2);
                $table->decimal('vrAcrescimo',9, 2);
                $table->decimal('vrSaldoAnterior',9, 2);
                $table->decimal('vrQuitado',9, 2);
                $table->boolean('flNotaFiscal')->default(false);
                $table->boolean('flAtivo')->default(true);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::disableForeignKeyConstraints();
        Schema::dropIfExists('cli_Extrato');
        Schema::enableForeignKeyConstraints();
    }
}
