<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinContasBancariasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_ContasBancarias')) {
            Schema::create('fin_ContasBancarias', function (Blueprint $table) {
                $table->unsignedInteger('idContaBancaria', false);
                $table->string('stContaBancaria', 20);
                $table->string('stBanco', 20);
                $table->string('stAgencia', 10);
                $table->decimal('vrSaldo', 9, 2);
                $table->boolean('flAtivo');
                $table->dateTime('dtAlteracao');
                $table->string('stApelido', 20);
                $table->boolean('flPoupanca');
                $table->primary('idContaBancaria');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public
    function down()
    {
        Schema::dropIfExists('fin_ContasBancarias');
    }
}
