<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateOpPerfisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('op_Perfis')) {
            Schema::create('op_Perfis', function (Blueprint $table) {
                $table->integer('idPerfil', false, true);
                $table->string('stDescricao', 50);
                $table->text('stIds');
                $table->dateTime('dtAlteracao')->default(Carbon::now());

                $table->primary('idPerfil');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('op_Perfis');
    }
}
