<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateStockModule extends Migration
{

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Stock Orders
        if (!Schema::hasTable('stock_order')) {
            Schema::create('stock_order', function (Blueprint $table) {

                $table->uuid('id')->primary();
                $table->integer('id_supplier')->nullable();
                $table->string('document', 50);
                $table->string('note', 100)->nullable();
                $table->date('date');
                $table->string('operator',20);

                $table->boolean('is_input');

                $table->foreign('id_supplier', 'foreign_id_supplier')
                    ->references('idFornecedor')
                    ->on('frn_Fornecedores');

                $table->timestamps();
            });
        }

        //Stock Items
        if (!Schema::hasTable('stock_order_itens')) {
            Schema::create('stock_order_itens', function (Blueprint $table) {
                $table->uuid('id')->primary();
                $table->smallInteger('id_item');
                $table->uuid('id_order');
                $table->integer('id_product');
                $table->string('description', 50);
                $table->string('uom', 10);
                $table->decimal('quantity', 8, 3);
                $table->decimal('value', 8, 3);
                $table->boolean('is_input');
                $table->foreign('id_order')
                    ->references('id')
                    ->on('stock_order');

                $table->foreign('id_product', 'foreign_id_product')
                    ->references('idProduto')
                    ->on('prd_produtos');
                $table->timestamps();
            });
        }

        //Stock Balance
        if (!Schema::hasTable('stock_balance')) {
            Schema::create('stock_balance', function (Blueprint $table) {
                $table->uuid('id')->primary();
//                $table->increments('index');
                $table->string('calendar', 7);
                $table->integer('id_product');

                $table->foreign('id_product', 'foreign_product_id_balance')
                    ->references('idProduto')
                    ->on('prd_produtos');

                $table->decimal('initial_balance', 8, 3)->default(0);
                $table->decimal('01', 8, 3)->default(0);
                $table->decimal('02', 8, 3)->default(0);
                $table->decimal('03', 8, 3)->default(0);
                $table->decimal('04', 8, 3)->default(0);
                $table->decimal('05', 8, 3)->default(0);
                $table->decimal('06', 8, 3)->default(0);
                $table->decimal('07', 8, 3)->default(0);
                $table->decimal('08', 8, 3)->default(0);
                $table->decimal('09', 8, 3)->default(0);
                $table->decimal('10', 8, 3)->default(0);
                $table->decimal('11', 8, 3)->default(0);
                $table->decimal('12', 8, 3)->default(0);
                $table->decimal('13', 8, 3)->default(0);
                $table->decimal('14', 8, 3)->default(0);
                $table->decimal('15', 8, 3)->default(0);
                $table->decimal('16', 8, 3)->default(0);
                $table->decimal('17', 8, 3)->default(0);
                $table->decimal('18', 8, 3)->default(0);
                $table->decimal('19', 8, 3)->default(0);
                $table->decimal('20', 8, 3)->default(0);
                $table->decimal('21', 8, 3)->default(0);
                $table->decimal('22', 8, 3)->default(0);
                $table->decimal('23', 8, 3)->default(0);
                $table->decimal('24', 8, 3)->default(0);
                $table->decimal('25', 8, 3)->default(0);
                $table->decimal('26', 8, 3)->default(0);
                $table->decimal('27', 8, 3)->default(0);
                $table->decimal('28', 8, 3)->default(0);
                $table->decimal('29', 8, 3)->default(0);
                $table->decimal('30', 8, 3)->default(0);
                $table->decimal('31', 8, 3)->default(0);
                $table->decimal('final_balance', 8, 3)->default(0);

                $table->timestamps();

            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('stock_orders_itens');
        Schema::dropIfExists('stock_orders');
        Schema::dropIfExists('stock_balance');
    }

}
