<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class CreateItemSalesView extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::statement($this->dropView());
        DB::statement($this->createView());
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::statement($this->dropView());
    }

    private function createView()
    {
        return 'create view sales_item_list as
           select idItem, idVenda,idAbertura, idCodProduto as codigo, p.stProdutoAbreviado as descricao, m.stMedida as medida, i.nrQuantidade as quantidade, i.vrUnitario as valor, i.vrTotal as total from  cx_itens i
            inner join prd_Produtos p on p.idProduto = i.idProduto
            inner join prd_Medidas m on m.idMedida = p.idMedida

            union

            select idItem, idVenda,idAbertura, idCodProduto as codigo, p.stProdutoAbreviado as descricao, m.stMedida as medida, i.nrQuantidade as quantidade, i.vrUnitario as valor, i.vrTotal as total from  cx_Itens_Temp i
            inner join prd_Produtos p on p.idProduto = i.idProduto
            inner join prd_Medidas m on m.idMedida = p.idMedida';
    }
    /**
     * Reverse the migrations.
     *
     * @return string
     */
    private function dropView()
    {
        return "if exists(select 1 from sys.views where name='sales_item_list' and type='v')
                drop view sales_item_list;";
    }
}
