<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMobyoConfigTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mobyo_config')) {
            Schema::create('mobyo_config', function (Blueprint $table) {
                $table->id();
                $table->string('engine', 50)->nullable();
                $table->string('idMerchant', 50);
                $table->boolean('flClienteFixo')->default(true);
                $table->integer('idCliente')->nullable();
                $table->string('codProdutoGenerico')->nullable();
                $table->integer('idCaixa')->default(16);
                $table->integer('idUser')->default(99);
                $table->boolean('flFormaPagamentoFixa')->default(true);
                $table->integer('idFormaPagamento')->default(1);
                $table->string('idDeliveryPadrao')->default('127.0.0.1');
                $table->boolean('flClienteObservacao')->default(true);
                $table->boolean('flCupomDelivery')->default(true);
                $table->boolean('flCupomRemoto')->default(true);
                $table->boolean('flPainelPreparo')->default(false);
                $table->boolean('flSalvarVendaAutomatico')->default(false);
                $table->boolean('flCupomAutomatico')->default(false);
                $table->integer('idContaFinanceiro')->default(19);
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mobyo_config');
    }
}
