<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateKdsDisplaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('kds_displays')) {
            Schema::create('kds_displays', function (Blueprint $table) {
                $table->id();
                $table->string('idDevice', 100);
                $table->integer('tempoAlerta')->default(15)->nullable();
                $table->string('tipoVisualizacao', 100)->default('COMANDA')->nullable();
                $table->string('idSetor')->default('Geral');
                $table->boolean('exibirMesa')->default(true)->nullable();
                $table->boolean('exibirComanda')->default(true)->nullable();
                $table->boolean('exibirAtendente')->default(true)->nullable();
                $table->boolean('exibirTerminal')->default(true)->nullable();
                $table->boolean('exibirTempoPreparo')->default(true)->nullable();
                $table->timestamps();
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('kds_displays');
    }
}
