<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class OpPermissoesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (!DB::table('op_Permissoes')->count()) {

            $data = [
                ['idPermissao' => 1, 'stPermissao' => 'Estornar Item' ,'idCategoria' => 2, 'stDescricao' => 'Estornar um item da venda em questão', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 2, 'stPermissao' => 'Cancelar Cupom' ,'idCategoria' => 2, 'stDescricao' => 'Cancela a impressão de um cupom em andamento', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 3, 'stPermissao' => 'Reducao Z' ,'idCategoria' => 2, 'stDescricao' => 'Emitir Redução Z', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 4, 'stPermissao' => 'Desconto' ,'idCategoria' => 2, 'stDescricao' => 'Realizar descontos sobre uma venda', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 5, 'stPermissao' => 'Abrir Gaveta' ,'idCategoria' => 2, 'stDescricao' => 'Abrir a gaveta de dinheiro a qualquer momento', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 6, 'stPermissao' => 'Leitura X' ,'idCategoria' => 2, 'stDescricao' => 'Emitir Leitura X', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 7, 'stPermissao' => 'Modulo Produtos' ,'idCategoria' => 1, 'stDescricao' => 'Acessar o módulo de Produtos no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 8, 'stPermissao' => 'Modulo NATI' ,'idCategoria' => 1, 'stDescricao' => 'Acessar o NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 9, 'stPermissao' => 'Modulo Caixa' ,'idCategoria' => 2, 'stDescricao' => 'Acessar o Caixa', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 10, 'stPermissao' => 'Administrar Produto' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de um produto', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 11, 'stPermissao' => 'Modulo Microterminal' ,'idCategoria' => 3, 'stDescricao' => 'Utilizar o microterminal', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 12, 'stPermissao' => 'Cancelar Venda' ,'idCategoria' => 2, 'stDescricao' => 'Cancela uma venda já finalizada', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 13, 'stPermissao' => 'Mudar modo Fiscal' ,'idCategoria' => 2, 'stDescricao' => 'Configuração', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 14, 'stPermissao' => 'Configuracoes Caixa' ,'idCategoria' => 2, 'stDescricao' => 'Acessar a tela de configuração do caixa', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 15, 'stPermissao' => 'Controlar Estoque' ,'idCategoria' => 2, 'stDescricao' => 'Controlar Estoque', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 16, 'stPermissao' => 'Movimentacao' ,'idCategoria' => 2, 'stDescricao' => 'Movimentação', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 17, 'stPermissao' => 'Suprimento Sangria' ,'idCategoria' => 2, 'stDescricao' => 'Realizar a retirada de uma importância do caixa', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 18, 'stPermissao' => 'Abrir Caixa em Uso' ,'idCategoria' => 2, 'stDescricao' => 'Abrir um caixa iniciado por outro operador', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 19, 'stPermissao' => 'Modulo Operador' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao módulo de Operadores no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 20, 'stPermissao' => 'Modulo Clientes' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao módulo de Clientes no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 21, 'stPermissao' => 'Alterar Saldo' ,'idCategoria' => 1, 'stDescricao' => 'Alterar o saldo de um cliente cadastrado', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 22, 'stPermissao' => 'Administrar Clientes' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de um cliente', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 23, 'stPermissao' => 'Administrar Operador' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de um Operador', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 24, 'stPermissao' => 'Emitir Relatorios' ,'idCategoria' => 1, 'stDescricao' => 'Gerar relatórios em geral', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 25, 'stPermissao' => 'Deletar Produto' ,'idCategoria' => 1, 'stDescricao' => 'Deletar o cadastro de um produto', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 26, 'stPermissao' => 'Modulo Impressora' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao módulo de Impressoras no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 27, 'stPermissao' => 'Administrar Microterminal' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de um microterminal', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 28, 'stPermissao' => 'Administrar Impressora' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de uma impressora', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 29, 'stPermissao' => 'Modulo Fornecedores' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao módulo de Fornecedores no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 30, 'stPermissao' => 'Administrar Fornecedores' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de um fornecedor', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 31, 'stPermissao' => 'Des/Bloquear Comanda' ,'idCategoria' => 1, 'stDescricao' => 'Bloquear ou desbloquear uma determinada comanda', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 32, 'stPermissao' => 'Anular Venda' ,'idCategoria' => 2, 'stDescricao' => 'Cancelar uma venda em andamento', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 33, 'stPermissao' => 'Modulo Presidente' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao módulo de Presidente no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 34, 'stPermissao' => 'Caixa OnLine' ,'idCategoria' => 1, 'stDescricao' => 'Visualizar a posição instantanea dos caixas abertos', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 35, 'stPermissao' => 'Fechamento' ,'idCategoria' => 2, 'stDescricao' => 'Realizar o fechamento de caixa', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 36, 'stPermissao' => 'Venda Pendura' ,'idCategoria' => 2, 'stDescricao' => 'Realizar uma venda com a forma de pagamento Conta Assinada', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 37, 'stPermissao' => 'Limite' ,'idCategoria' => 2, 'stDescricao' => 'Limite', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 38, 'stPermissao' => 'Exceder Limite' ,'idCategoria' => 2, 'stDescricao' => 'Realizar uma venda com a forma de pagamento Conta Assinada para um cliente que excedeu seu limite', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 39, 'stPermissao' => 'Exceder Valor de Venda' ,'idCategoria' => 2, 'stDescricao' => 'Realizar uma venda com um valor superior ao limite imposto pela gerência', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 40, 'stPermissao' => 'Exceder Valor Desconto' ,'idCategoria' => 2, 'stDescricao' => 'Realizar uma venda com um valor de desconto superior ao limite imposto pela gerência', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 41, 'stPermissao' => 'Pagamento Pendura' ,'idCategoria' => 2, 'stDescricao' => 'Depositar uma importância na Conta Assinada de um cliente', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 42, 'stPermissao' => 'Pagamento Fornecedor' ,'idCategoria' => 2, 'stDescricao' => 'Ralizar uma retirada do caixa para efetuar o pagamento de um fornecedor', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 43, 'stPermissao' => 'Pagamento Despesas' ,'idCategoria' => 2, 'stDescricao' => 'Ralizar uma retirada do caixa para efetuar o pagamento de uma despesa', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 44, 'stPermissao' => 'Ultimas Vendas' ,'idCategoria' => 2, 'stDescricao' => 'Ultimas Vendas', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 45, 'stPermissao' => 'Visualizar Movimentacao' ,'idCategoria' => 2, 'stDescricao' => 'Visualizar Movimentação', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 46, 'stPermissao' => 'Modulo Estoque' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao módulo de Estoques no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 47, 'stPermissao' => 'Administrar Estoques' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de um Estoque', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 48, 'stPermissao' => 'Lancar Estoque' ,'idCategoria' => 1, 'stDescricao' => 'Realizar uma movimentação de entrada ou saída de produtos em um determinado estoque', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 49, 'stPermissao' => 'Consultar Estoque' ,'idCategoria' => 2, 'stDescricao' => 'Realizar uma consulta de estoque', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 50, 'stPermissao' => 'Modulo Despesas' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao módulo de Despesas no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 51, 'stPermissao' => 'Administrar Despesas' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de uma Despesa', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 52, 'stPermissao' => 'Modulo Formas de Pagamento' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao módulo de Formas de Pagamento no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 53, 'stPermissao' => 'Administrar Formas de Pagamento' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de uma forma de pagamento', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 54, 'stPermissao' => 'Reimpimir Cupom' ,'idCategoria' => 2, 'stDescricao' => 'Faz uma nova impressão do cupom fiscal', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 55, 'stPermissao' => 'Modulo Relatórios' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao módulo de Relatórios no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 56, 'stPermissao' => 'Relatórios de Estoque' ,'idCategoria' => 1, 'stDescricao' => 'Acesso aos relatórios referentes a estoque', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 57, 'stPermissao' => 'Relatórios Administrativos' ,'idCategoria' => 1, 'stDescricao' => 'Acesso aos relatórios com critério gerencial', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 58, 'stPermissao' => 'Limpar Banco' ,'idCategoria' => 1, 'stDescricao' => 'Permite excluir dados referentes a faturamento no banco de dados', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 59, 'stPermissao' => 'Módulo Delivery' ,'idCategoria' => 4, 'stDescricao' => 'Acessar o Delivery', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 60, 'stPermissao' => 'Módulo Financeiro' ,'idCategoria' => 5, 'stDescricao' => 'Acessar o Financeiro', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 61, 'stPermissao' => 'Cancelar Pedido' ,'idCategoria' => 4, 'stDescricao' => 'Permite o cancelamento de um pedido que não esteja mais em formulação', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 62, 'stPermissao' => 'Módulo Compras' ,'idCategoria' => 6, 'stDescricao' => 'Acessar Compras', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 63, 'stPermissao' => 'Alterar Forma Pagamento' ,'idCategoria' => 2, 'stDescricao' => 'Permite alterar a forma de pagamento para o delivery', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 64, 'stPermissao' => 'Baixar Saldos dos Clientes' ,'idCategoria' => 1, 'stDescricao' => 'Permite dar baixa nos saldos dos clientes através do relatório de Faturas por Empresas.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 65, 'stPermissao' => 'Funções do TEF' ,'idCategoria' => 2, 'stDescricao' => 'Permite utilizar todas as funções do TEF', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 66, 'stPermissao' => 'Retornar comanda no caixa' ,'idCategoria' => 2, 'stDescricao' => 'Permite que o operador do caixa retorne uma comanda  ja lancada devolta.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 67, 'stPermissao' => 'Acesso Remoto' ,'idCategoria' => 1, 'stDescricao' => 'Permite acessar o NATI através da internet.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 68, 'stPermissao' => 'Administrar Cadastros' ,'idCategoria' => 5, 'stDescricao' => 'Permite administrar toda a área de cadastros do módulo Financeiro.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 69, 'stPermissao' => 'Fazer Lançamentos' ,'idCategoria' => 5, 'stDescricao' => 'Permite adicionar contas a pagar e receber no sistema.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 70, 'stPermissao' => 'Administrar Lançamentos' ,'idCategoria' => 5, 'stDescricao' => 'Permite editar ou excluir notas lançadas.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 71, 'stPermissao' => 'Emitir Extrato' ,'idCategoria' => 5, 'stDescricao' => 'Permite visualizar a movimentação das contas.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 72, 'stPermissao' => 'Movimentar Contas' ,'idCategoria' => 5, 'stDescricao' => 'Permite sacar ou depositar importâncias nas contas.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 73, 'stPermissao' => 'Baixar contas' ,'idCategoria' => 5, 'stDescricao' => 'Permite dar baixa nas contas pendentes.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 74, 'stPermissao' => 'corrigir' ,'idCategoria' => 5, 'stDescricao' => 'Permite excluir despesas', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 75, 'stPermissao' => 'Excluir item do extrato' ,'idCategoria' => 5, 'stDescricao' => 'Permite excluir itens do extrato de contas bancrias.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 76, 'stPermissao' => 'Cadastrar Impresso Digita' ,'idCategoria' => 1, 'stDescricao' => 'Permite o usurio cadastrar um Impresso Digita', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 77, 'stPermissao' => 'Consultar Comanda' ,'idCategoria' => 2, 'stDescricao' => 'Consultar Comanda', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 78, 'stPermissao' => 'Excluir Item do Caixa' ,'idCategoria' => 2, 'stDescricao' => 'Permite excluir um item inserido apenas no caixa, ou seja, que no tenha sido informado atravex de uma comanda', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 79, 'stPermissao' => 'Efetuar Repique' ,'idCategoria' => 2, 'stDescricao' => 'Efetuar um repique no caixa fora de uma venda com troco', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 80, 'stPermissao' => 'Re-Imprimir Cupom' ,'idCategoria' => 4, 'stDescricao' => 'Permite realizar a re-impresso do cupom de Delivery', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 81, 'stPermissao' => 'Utilizar fila de vendas' ,'idCategoria' => 2, 'stDescricao' => 'Utilizar fila de vendas no modulo caixa.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 82, 'stPermissao' => 'Permitir recebimento pendura' ,'idCategoria' => 2, 'stDescricao' => 'Permitir recebimento pendura no caixa.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 83, 'stPermissao' => 'Administrar Funcionarios' ,'idCategoria' => 1, 'stDescricao' => 'Cadastrar e editar o cadastro de um funcionario', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 84, 'stPermissao' => 'Modulo Funcionarios' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao mdulo de Funcionarios no NATI', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 85, 'stPermissao' => 'Alterar Recebimento' ,'idCategoria' => 2, 'stDescricao' => 'Alterar recebimento depois que uma venda foi concluida', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 86, 'stPermissao' => 'Reabrir Venda' ,'idCategoria' => 2, 'stDescricao' => 'Reabrir uma venda apos a concluso da mesma', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 87, 'stPermissao' => 'Incluir Preo' ,'idCategoria' => 6, 'stDescricao' => 'Permite que seja cadastrada uma nova referencia de custo', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 88, 'stPermissao' => 'Administrar Oramentos' ,'idCategoria' => 6, 'stDescricao' => 'Permite criar, editar ou excluir um oramento', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 89, 'stPermissao' => 'Administrar Pedidos' ,'idCategoria' => 6, 'stDescricao' => 'Permite criar, editar ou excluir um pedido de compra', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 90, 'stPermissao' => 'Incluir Pedido' ,'idCategoria' => 6, 'stDescricao' => 'Permite transformar um oramento em um pedido definitivo', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 91, 'stPermissao' => 'Baixar Pedido' ,'idCategoria' => 6, 'stDescricao' => 'Permite dar baixa em um pedido, juntamente com entradas para estoque e financeiro', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 92, 'stPermissao' => 'Módulo Caixa Browser' ,'idCategoria' => 7, 'stDescricao' => 'Acessar o Caixa versão browser', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 93, 'stPermissao' => 'Exceder limite para produto generico' ,'idCategoria' => 2, 'stDescricao' => 'Exceder limite para produto generico', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 94, 'stPermissao' => 'Autorizar baixa' ,'idCategoria' => 5, 'stDescricao' => 'Permite autorizar a baixa de um titulo', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 95, 'stPermissao' => 'Baixar sem Autorização' ,'idCategoria' => 5, 'stDescricao' => 'Permite dar baixa em um titulo que n?o esteja autorizado', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 96, 'stPermissao' => 'Re-Abrir Pedido' ,'idCategoria' => 4, 'stDescricao' => 'Volta um pedido com status SAIU PARA ENTREGA para PENDENTE', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 97, 'stPermissao' => 'Autorizar aferição' ,'idCategoria' => 2, 'stDescricao' => 'Autorizar aferição de combustivel no caixa.', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 98, 'stPermissao' => 'Realizar Vauchers' ,'idCategoria' => 2, 'stDescricao' => 'Permite realizar vauchers', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 99, 'stPermissao' => 'Finalizar Vaucher' ,'idCategoria' => 2, 'stDescricao' => 'Permite a finalização de um Vaucher', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 100, 'stPermissao' => 'Visualizar valores no relatorio de vendas' ,'idCategoria' => 1, 'stDescricao' => 'Permite visualizar valores no relatorio de vendas', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 101, 'stPermissao' => 'Limpar Taxa de Servico' ,'idCategoria' => 2, 'stDescricao' => 'Permite retirar o valor da taxa de servico da venda', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 102, 'stPermissao' => 'Alterar Quantidade' ,'idCategoria' => 2, 'stDescricao' => 'Permite alterar a quantidade de um produto no Módulo Restaurante', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 103, 'stPermissao' => 'Relatório Gerencial' ,'idCategoria' => 2, 'stDescricao' => 'Permite Imprimir Relatório Gerencial', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 104, 'stPermissao' => 'Relatório Totais' ,'idCategoria' => 2, 'stDescricao' => 'Permite Imprimir Relatório Totais', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 105, 'stPermissao' => 'Transferir Mesa' ,'idCategoria' => 2, 'stDescricao' => 'Permite transferir todos os itens de uma mesa para outra no Módulo Restaurante', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 106, 'stPermissao' => 'Reabrir Mesa' ,'idCategoria' => 2, 'stDescricao' => 'Permite reabrir mesas que já emitiram conta, ou seja, que foram fechadas no Módulo Restaurante', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 107, 'stPermissao' => 'Lancamento Vencido' ,'idCategoria' => 5, 'stDescricao' => 'Permite realizar lancamentos de titulos em datas vencidas', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 108, 'stPermissao' => 'Administar Ordem de Compra' ,'idCategoria' => 8, 'stDescricao' => 'Permite cadastrar, editar, excluir, receber e analisar uma Ordem de Compra', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 109, 'stPermissao' => 'Gerar SPED' ,'idCategoria' => 8, 'stDescricao' => 'Permite gerar arquivo SPED', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 110, 'stPermissao' => 'Cadastrar Crédito e Rateio' ,'idCategoria' => 8, 'stDescricao' => 'Permite efetuar cadstro de crédito e rateio', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 111, 'stPermissao' => 'Administrar Contabilista' ,'idCategoria' => 8, 'stDescricao' => 'Permite cadastrar, editar, excluir e alterar o status de um contabilista', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 112, 'stPermissao' => 'Lançamento de Serviço' ,'idCategoria' => 8, 'stDescricao' => 'Permite fazer lançamento de serviços', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 113, 'stPermissao' => 'Excluir Fechamento de Caixa' ,'idCategoria' => 1, 'stDescricao' => 'Excluir Fechamento de Caixa. (Exclui todas as vendas e recebimento da abertura de caixa, não sendo possivel a recuperação das informações.)', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 114, 'stPermissao' => 'Limpa Movimento' ,'idCategoria' => 1, 'stDescricao' => 'Remover a movimentacao de um periodo da base de dados', 'dtAlteracao' => Carbon::now()],
                ['idPermissao' => 115, 'stPermissao' => 'Permite dar baixa em delivery' ,'idCategoria' => 2, 'stDescricao' => 'Dar baixa em delivery', 'dtAlteracao' => Carbon::now()]
            ];

            DB::table('op_Permissoes')->insert($data);

        }
        $permissao = DB::select('select *from op_Permissoes where idPermissao = 120');

        if(!$permissao){
            DB::table('op_Permissoes')->insert([
                'idPermissao' => 120, 'stPermissao' => 'Permite acessar o painel de alíquotas' ,'idCategoria' => 1, 'stDescricao' => 'Painel de Alíquotas', 'dtAlteracao' => Carbon::now()
            ]);
        }

        $permissao= DB::select('select *from op_Permissoes where idPermissao = 130');
        if(!$permissao){
            DB::table('op_Permissoes')->insert([
                'idPermissao' => 130, 'stPermissao' => 'Permite adicionar Adiantamento em uma Mesa/Comanda' ,'idCategoria' => 2, 'stDescricao' => 'Adiantamento Mesa/Comanda', 'dtAlteracao' => Carbon::now(),
            ]);
        }

        $permissao= DB::select('select *from op_Permissoes where idPermissao = 131');
        if(!$permissao){
            DB::table('op_Permissoes')->insert([
                'idPermissao' => 131, 'stPermissao' => 'Permite deletar Adiantamento de uma Mesa/Comanda' ,'idCategoria' => 2, 'stDescricao' => 'Adiantamento Mesa/Comanda', 'dtAlteracao' => Carbon::now()
            ]);
        }

        //DELETE PERMISSIONS
        $permissao= DB::select('select * from op_Permissoes where idPermissao = 97');
        if($permissao){
            DB::table('op_Permissoes')->where('idPermissao', '=', 97)->delete();
        }
        $perfilPermissions = DB::select("select idPerfil, stIds from op_Perfis where stIds like '%97%'");
        if(!empty($perfilPermissions)){
            foreach($perfilPermissions as $item){
                $item->stIds = str_replace("[", " ,", $item->stIds);
                $item->stIds = str_replace("]", ", ", $item->stIds);
                $item->stIds = str_replace(",97,", ",", $item->stIds);
                $item->stIds = str_replace(" ,", "[", $item->stIds);
                $item->stIds = str_replace(", ", "]", $item->stIds);
                DB::update("update op_perfis
                            set stIds = '$item->stIds'
                            where idPerfil = '$item->idPerfil'");
            };
        }

        $permissao= DB::select('select * from op_Permissoes where idPermissao = 13');
        if($permissao){
            DB::table('op_Permissoes')->where('idPermissao', '=', 13)->delete();
        }
        $perfilPermissions = DB::select("select idPerfil, stIds from op_Perfis where stIds like '%13%'");
        if(!empty($perfilPermissions)){
            foreach($perfilPermissions as $item){
                $item->stIds = str_replace("[", " ,", $item->stIds);
                $item->stIds = str_replace("]", ", ", $item->stIds);
                $item->stIds = str_replace(",13,", ",", $item->stIds);
                $item->stIds = str_replace(" ,", "[", $item->stIds);
                $item->stIds = str_replace(", ", "]", $item->stIds);
                DB::update("update op_perfis
                            set stIds = '$item->stIds'
                            where idPerfil = '$item->idPerfil'");
            };
        }

        $permissao= DB::select('select * from op_Permissoes where idPermissao = 43');
        if($permissao){
            DB::table('op_Permissoes')->where('idPermissao', '=', 43)->delete();
        }
        $perfilPermissions = DB::select("select idPerfil, stIds from op_Perfis where stIds like '%43%'");
        if(!empty($perfilPermissions)){
            foreach($perfilPermissions as $item){
                $item->stIds = str_replace("[", " ,", $item->stIds);
                $item->stIds = str_replace("]", ", ", $item->stIds);
                $item->stIds = str_replace(",43,", ",", $item->stIds);
                $item->stIds = str_replace(" ,", "[", $item->stIds);
                $item->stIds = str_replace(", ", "]", $item->stIds);
                DB::update("update op_perfis
                            set stIds = '$item->stIds'
                            where idPerfil = '$item->idPerfil'");
            };
        }

        $permissao= DB::select('select * from op_Permissoes where idPermissao = 83');
        if($permissao){
            DB::table('op_Permissoes')->where('idPermissao', '=', 83)->delete();
        }
        $perfilPermissions = DB::select("select idPerfil, stIds from op_Perfis where stIds like '%83%'");
        if(!empty($perfilPermissions)){
            foreach($perfilPermissions as $item){
                $item->stIds = str_replace("[", " ,", $item->stIds);
                $item->stIds = str_replace("]", ", ", $item->stIds);
                $item->stIds = str_replace(",83,", ",", $item->stIds);
                $item->stIds = str_replace(" ,", "[", $item->stIds);
                $item->stIds = str_replace(", ", "]", $item->stIds);
                DB::update("update op_perfis
                            set stIds = '$item->stIds'
                            where idPerfil = '$item->idPerfil'");
            };
        }

        $permissao= DB::select('select * from op_Permissoes where idPermissao = 51');
        if($permissao){
            DB::table('op_Permissoes')->where('idPermissao', '=', 51)->delete();
        }
        $perfilPermissions = DB::select("select idPerfil, stIds from op_Perfis where stIds like '%51%'");
        if(!empty($perfilPermissions)){
            foreach($perfilPermissions as $item){
                $item->stIds = str_replace("[", " ,", $item->stIds);
                $item->stIds = str_replace("]", ", ", $item->stIds);
                $item->stIds = str_replace(",51,", ",", $item->stIds);
                $item->stIds = str_replace(" ,", "[", $item->stIds);
                $item->stIds = str_replace(", ", "]", $item->stIds);
                DB::update("update op_perfis
                            set stIds = '$item->stIds'
                            where idPerfil = '$item->idPerfil'");
            };
        }

        $permissao= DB::select('select * from op_Permissoes where idPermissao = 58');
        if($permissao){
                DB::table('op_Permissoes')->where('idPermissao', '=', 58)->delete();
            }
        $perfilPermissions = DB::select("select idPerfil, stIds from op_Perfis where stIds like '%58%'");
        if(!empty($perfilPermissions)){
            foreach($perfilPermissions as $item){
                $item->stIds = str_replace("[", " ,", $item->stIds);
                $item->stIds = str_replace("]", ", ", $item->stIds);
                $item->stIds = str_replace(",58,", ",", $item->stIds);
                $item->stIds = str_replace(" ,", "[", $item->stIds);
                $item->stIds = str_replace(", ", "]", $item->stIds);
                DB::update("update op_perfis
                            set stIds = '$item->stIds'
                            where idPerfil = '$item->idPerfil'");
            };
        }

        $permissao= DB::select('select * from op_Permissoes where idPermissao = 76');
        if($permissao){
                DB::table('op_Permissoes')->where('idPermissao', '=', 76)->delete();
            }
        $perfilPermissions = DB::select("select idPerfil, stIds from op_Perfis where stIds like '%76%'");
        if(!empty($perfilPermissions)){
            foreach($perfilPermissions as $item){
                $item->stIds = str_replace("[", " ,", $item->stIds);
                $item->stIds = str_replace("]", ", ", $item->stIds);
                $item->stIds = str_replace(",76,", ",", $item->stIds);
                $item->stIds = str_replace(" ,", "[", $item->stIds);
                $item->stIds = str_replace(", ", "]", $item->stIds);
                DB::update("update op_perfis
                            set stIds = '$item->stIds'
                            where idPerfil = '$item->idPerfil'");
            };
        }

        //Permissão necessaria para o PDV ecf
        $permissao= DB::select('select * from op_Permissoes where idPermissao = 3');
        if(!$permissao){
            DB::table('op_Permissoes')->insert([
                'idPermissao' => 3, 'stPermissao' => 'Redução Z' ,'idCategoria' => 2, 'stDescricao' => 'Emitir Redução Z', 'dtAlteracao' => Carbon::now()
            ]);
        }

        //Permissão necessario para modulo de usuarios do nati
        $permissao= DB::select('select * from op_Permissoes where idPermissao = 84');
        if(!$permissao){
            DB::table('op_Permissoes')->insert([
                'idPermissao' => 84, 'stPermissao' => 'Modulo Funcionarios' ,'idCategoria' => 1, 'stDescricao' => 'Acesso ao mdulo de Funcionarios no NATI', 'dtAlteracao' => Carbon::now()
            ]);
        }

    }
}
