<?

require_once "functions.php";
require_once "mobyoApiHelper.php";

if (strstr($_SERVER['SCRIPT_NAME'], "index.php") === false) {
    redirect("index.php");
    die;
}

permission(59);

$stObsGeral = strlen(htmlspecialchars(strtoupper(trim($_POST['stObsGeral'])), ENT_QUOTES)) > 0 ? htmlspecialchars(strtoupper(trim($_POST['stObsGeral'])), ENT_QUOTES) : NULL;
$paymentMethod = $_POST['paymentMethod'];
$orderType = $_POST['orderType'];
$deliveryType = $_POST['deliveryType'];
$orderId = $_POST['orderId'];
$deliveryFee = (float)$_POST['deliveryFee'];
$additionalFees = (float)$_POST['convenienceFees'];
$vrFormaPagamento = $deliveryFee + $additionalFees;

$res = mssql_query("SELECT * FROM dlv_Atendimentos WHERE idAtendimento = '$orderId'");
$atendimento = mssql_fetch_array($res);

$res = mssql_query("SELECT * FROM dlv_Itens WHERE idAtendimento = '$orderId'");
$items = [];

while ($item = mssql_fetch_array($res)) {
    $query = mssql_query("SELECT * FROM prd_Produtos WHERE idProduto = $item[idProduto]");
    $product = mssql_fetch_array($query);
    $price = $item['nrQuantidade'] * $item['vrUnitario'];
    $items[] = [
        "externalCode" => "",
        "name" => $product['stProduto'],
        "observations" => $item['stObservacoes'],
        "price" => (float)$price,
        "quantity" => (float)$item['nrQuantidade'],
        "totalPrice" => (float)$price,
        "unitPrice" => (float)$item['vrUnitario']
    ];
    $vrFormaPagamento += $price;
};

$res = mssql_query("SELECT * FROM dlv_Clientes WHERE idCliente = '$atendimento[idCliente]'");
$cliente = mssql_fetch_array($res);

$res = mssql_query("SELECT * FROM dlv_CEPs WHERE idCEP = '$cliente[idCEP]'");
$endereco = mssql_fetch_array($res);

$res = mssql_query("SELECT * FROM dlv_Telefones WHERE idCliente = '$cliente[idCliente]'");
$telefone = mssql_fetch_array($res);

$order = [
    "customer" => [
        "address" => [
            "city" => $endereco['stCidade'],
            "complement" => "",
            "neighborhood" => $endereco['stBairro'],
            "country" => "Brazil",
            "postalCode" => $endereco['stCEP'],
            "state" => $endereco['stEstado'],
            "streetName" => $endereco['stEndereco'],
            "streetNumber" => $cliente['nrNumero']
        ],
        "internationalCode" => "+55",
        "name" => $cliente['stCliente'],
        "phoneNumber" => $telefone['nrTelefone'],
        "doc" => isset($cliente['stCPF_CNPJ']) ? strval($cliente['stCPF_CNPJ']) : null
    ],
    "deliveryType" => $deliveryType,
    "integrationId" => $orderId,
    "isTest" => true,
    "items" => $items,
    "orderType" => strtoupper($orderType),
    "paymentMethod" => strtoupper($paymentMethod),
    "reference" => $orderId,
    "deliveryFee" => $deliveryFee,
    "callbacks" => [],
];

$paymentMethodMap = [
    "PIX" => "wallet",
    "CREDIT" => "credit",
    "DEBIT" => "debit",
    "CASH" => "default",
];

$paymentMethodMapResult = $paymentMethodMap[$paymentMethod];
if (!$paymentMethodMapResult) {
    redirect("index.php?sec=montarPedido&id=" . $orderId . "&erro=11");
    return;
}

$res = mssql_query("SELECT C.codProdutoGenerico as code, P.idFormaPagamento as id FROM mobyo_config as C JOIN mobyo_payments as P ON C.id = P.idMobyoConfig AND P.name = '$paymentMethodMapResult' WHERE C.engine = 'mobyo'");
$result = mssql_fetch_array($res);
$paymentMethodId = $result['id'];
$productCodeGeneric = $result['code'];

if (!$paymentMethodId) {
    redirect("index.php?sec=montarPedido&id=" . $orderId . "&erro=11");
    return;
}

$response = MobyoApiHelper::createOrder($order);

if ($response['message']) {
    redirect("index.php?sec=montarPedido&id=" . $orderId . "&erro=12&message=" . $response['message']);
    return;
}

$idMobyo = $response['item']['id'];
$status = $response['item']['status'];

if (!$idMobyo) {
    redirect("index.php?sec=montarPedido&id=" . $orderId . "&erro=12&message=Falha ao criar pedido no MOBYO!");
    return;
}

if ($status != 'PENDING' && $status != 'PLACED') {
    redirect("index.php?sec=montarPedido&id=" . $orderId . "&erro=10");
    return;
}

$UID = $_POST['idOperador'] ? $_POST['idOperador'] : $_COOKIE['dlvOperador'];
$res = mssql_query("SELECT * FROM op_Operadores WHERE idOperador = '$UID'");
$arr = mssql_fetch_array($res);
$APELIDO = $arr['stApelido'];

$query = "SELECT P.*,
[A].[CfopSaida] AS cfop,
[A].[CstIcms] AS cstIcms,
[A].[AliquotaIcms] AS aliquotaIcms,
[A].[CstPis] AS cstPis,
[A].[AliquotaPis] AS aliquotaPis,
[A].[CstCofins] AS cstCofins,
[A].[AliquotaCofins] AS aliquotaCofins,
[CTM].[vrAliqNac] AS ibpt,
[M].[stMedida] AS medida,
[M].[flFracionado] AS flFracionado,
[C].[idCodigo] AS idCodigo
FROM prd_Produtos P
JOIN prd_Codigos C ON C.idProduto = P.idProduto
JOIN prd_Aliquotas A ON A.idAliquota = P.idAliquota
JOIN prd_Medidas M ON M.idMedida = P.idMedida
LEFT JOIN tbt_CargaTributariaMedia CTM ON P.nrNCM = CTM.stCodigo COLLATE Latin1_General_CI_AI
WHERE C.idCodigo = '$productCodeGeneric' AND P.flAtivo = '1'";

$res = mssql_query($query);
$arr = mssql_fetch_array($res);

$vrUnitario = $arr['vrUnitario'];
$idProduto = $arr['idProduto'];
$idCodigo = $arr['idCodigo'];
$idMedida = $arr['idMedida'];
$flFracionado = $arr['flFracionado'];
$cfop = $arr['cfop'];
$descricao = substr($arr['stProdutoAbreviado'], 0, 27);
$ncm = $arr['nrNCM'];
$cstIcms = $arr['cstIcms'];
$aliquotaIcms = $arr['aliquotaIcms'];
$cstPis = $arr['cstPis'];
$aliquotaPis = $arr['aliquotaPis'];
$cstCofins = $arr['cstCofins'];
$aliquotaCofins = $arr['aliquotaCofins'];
$ibpt = $arr['ibpt'];
$medida = $arr['medida'];

$res = mssql_query("SELECT MAX(nrItem) as nrItem FROM dlv_Itens WHERE idAtendimento = '$orderId'");
$arr = mssql_fetch_array($res);
$nrItem = $arr[0] + 1;

$transacao = true;
beginTransaction();

mssql_query("INSERT INTO dlv_Itens (idAtendimento, nrItem, idProduto, stOperador, nrQuantidade, dtData, vrUnitario, vrTotal, codigo, descricao, cfop, ncm, cstIcms, aliquotaIcms, cstPis, aliquotaPis, cstCofins, aliquotaCofins, ibpt, medida) VALUES ('$orderId', '$nrItem', '$idProduto', '$APELIDO', '1', getdate(), '$additionalFees', '$additionalFees', '$idCodigo', '$descricao','$cfop', '$ncm', '$cstIcms', $aliquotaIcms, '$cstPis', $aliquotaPis, '$cstCofins', $aliquotaCofins, " . ($ibpt ?? 0) . ", '$medida')");

$flTroco = 0;
$flAtivo = 1;

mssql_query("INSERT INTO dlv_FichaPagamentos (idFicha, idAtendimento, idFormaPagamento, vrFormaPagamento, dtData, flTroco, flAtivo) VALUES ('$idFicha', '$orderId', '$paymentMethodId', '$vrFormaPagamento', getdate(), '$flTroco', '$flAtivo')");

mssql_query("UPDATE dlv_Atendimentos SET stStatus = 'P', idMobyo = '$idMobyo', tipoDeEntrega = '$deliveryType'  WHERE idAtendimento = '$orderId'");

if ($paymentMethod == 'PIX') {
    $urlQrImage = $response['item']['payments']['methods'][0]['pix']['urlQrImage'];
    $pixKey = $response['item']['payments']['methods'][0]['pix']['pixKey'];
    mssql_query("UPDATE dlv_Atendimentos SET pixQrCodeMobyo = '$urlQrImage', pixChaveMobyo = '$pixKey'  WHERE idAtendimento = '$orderId'");
}

if ($transacao) {
    $res = mssql_query("SELECT * FROM dlv_Config WHERE idDelivery = '" . $_SERVER['REMOTE_ADDR'] . "'");
    $arr = mssql_fetch_array($res);

    $flPrintCupomPreparo = $arr['flPrintCupomPreparo'];

    commit();

    insertLog("DELIVERY", "PEDIDO [$orderId] CADASTRADO", $UID);

    if ($arr['stMarcaPrint'] != "SEM IMPRESSORA") {
        printCupom($orderId, $APELIDO);

        $res = mssql_query("SELECT * FROM dlv_Atendimentos WHERE idAtendimento = '$orderId'");
        $arr = mssql_fetch_array($res);

        if ($arr['flAgendarPedido'] && $flPrintCupomPreparo) {
            printCupomPreparo($orderId, $APELIDO);
            printCupomRetirada($orderId, $APELIDO);
        }
    }

    printCupomRemoto($orderId, $APELIDO);
    redirect("index.php?sec=listaPedidos");
} else {
    rollback();
    redirect("index.php?sec=montarPedido&id=" . $orderId . "&erro=5");
}
