<?php
require_once "Conexao.class.php";
class CxCaixaLoginClose extends Conexao {
    private $_name = "cx_caixa_login_close";
    
    public function __construct() {
        $sql = "IF OBJECT_ID('".$this->_name."') IS NULL
                    CREATE TABLE cx_caixa_login_close (
                    codcaixaloginclose INT NOT NULL IDENTITY (1, 1),
                    idoperador INT NOT NULL,
                    idcaixa INT NOT NULL,
                    [status] CHAR(1) NOT NULL,
                    descricao VARCHAR(300) NOT NULL,
                    data_acao DATE NOT NULL,
                    hora_acao TIME(7) NOT NULL,
                    PRIMARY KEY(codcaixaloginclose)
                );";
        try{
            parent::executar($sql);
        }catch(Exception $ex){
            throw (new Exception("FATAL ERROR - Erro ao tentar criar tabela: " . $ex->getMessage()));
        }
    }
    
    public function getNumRows($idoperador, $idcaixa, $data){
        $sql = "SELECT COUNT(*) as num FROM ".$this->_name." WHERE idoperador = ".$idoperador." AND idcaixa = ".$idcaixa." AND data_acao = '".$data."'";
        $objSource = parent::executar($sql);
        $objCaixa = mssql_fetch_object($objSource);
        return $objCaixa->num;
    }
    
    public function getAll($idoperador, $idcaixa, $data){
        $sql = "SELECT o.stApelido as operador, c.idcaixa, 
                        CASE c.status
                                WHEN '0' THEN 'ABRIU'
                                WHEN '1' THEN 'TENTOU FECHAR'
                        END as status,
                        c.descricao, c.data_acao, c.hora_acao
                FROM ".$this->_name." c
                INNER JOIN op_Operadores o
                ON o.idOperador = c.idoperador WHERE c.idoperador = ".$idoperador." AND c.idcaixa = ".$idcaixa." AND c.data_acao = '".$data."';";
        return parent::executar($sql);
    }
    
}
