<?php
require_once "../functions.php";

db_conn();

if (autorization(7) == false)
{
	?>
	<SCRIPT>
		document.location = "../?sec=erro&sub=2";
	</SCRIPT>
	<?
	die;
}

$idAbertura = htmlspecialchars($_GET['id'], ENT_QUOTES);
?>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>Detalhes das Sangrias</title>
	<link href="../css/style.css" type="text/css" rel="stylesheet"/>
	<link href="resources/css/bootstrap.min.css" rel="stylesheet"/>
	<link href="resources/css/custom.css" rel="stylesheet"/>
</head>
<body>
	<table class="display table table-striped table-bordered" width="100%" cellpadding="3" cellspacing="0" border="1" style="border-collapse: collapse" bordercolor="#FFFFFF">
		<caption class="table-caption">Detalhes das Sangrias</caption>
		<thead>
			<tr>
				<td class="tdStyle"><b>Por</b></td>
				<td class="tdStyle"><b>Em</b></td>
				<td class="tdStyle"><b>Tipo</b></td>
				<td class="tdStyle"><b>Valor</b></td>
			</tr>
		</thead>
		<?
		if (is_numeric($idAbertura))
		{
			$sql = "SELECT s.dtData, s.vrSangria, p.stApelido, f.stFormaPagamento ".
			"FROM cx_Sangrias s ".
			"INNER JOIN op_Operadores p ON s.idOperadorAutorizador = p.idOperador ".
			"INNER JOIN cx_FormasPagamento f ON s.idFormaPagamento = f.idFormaPagamento ".
			"INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura ".
			"WHERE s.flAtivo = '1' AND s.idAbertura = '$idAbertura' AND s.vrSangria > '0'";
		}
		else
		{
			$sql = "SELECT s.dtData, s.vrSangria, p.stApelido, f.stFormaPagamento ".
			"FROM cx_Sangrias s ".
			"INNER JOIN op_Operadores p ON s.idOperadorAutorizador = p.idOperador ".
			"INNER JOIN cx_FormasPagamento f ON s.idFormaPagamento = f.idFormaPagamento ".
			"INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura ".
			"WHERE s.flAtivo = '1' AND g.flAberto = '1' AND s.vrSangria > '0'";
		}

		$res = mssql_query($sql);

		while ($arr = mssql_fetch_array($res))
		{
			$dtData = strtotime($arr['dtData']);
			$dtData = date("d/m/y H:i", $dtData);

			?>
			<tr>
				<td class="tdStyle"><?php echo $arr['stApelido']?></td>
				<td class="tdStyle"><?php echo $dtData?></td>
				<td class="tdStyle"><?php echo $arr['stFormaPagamento']?></td>
				<td class="tdStyle" align="right">R$ <?php echo $arr['vrSangria']?></td>
			</tr>
			<?
		}

		if (is_numeric($idAbertura))
		{
			$sql = "SELECT SUM(vrSangria) as vrSangria FROM cx_Sangrias WHERE flAtivo = '1' AND idAbertura = '$idAbertura' AND vrSangria > '0'";
		}
		else
		{
			$sql = "SELECT SUM(s.vrSangria) as vrSangria FROM cx_Sangrias s ".
			"INNER JOIN cx_Gerenciador g ON s.idAbertura = g.idAbertura ".
			"WHERE s.flAtivo = '1' AND g.flAberto = '1' AND s.vrSangria > '0'";
		}

		$res = mssql_query($sql);
		$arr = mssql_fetch_array($res);
		?>
		<tr>
			<td class="tdStyle" colspan="3"><b>Valor Total:</b></td>
			<td class="tdStyle" align="right"><b>R$ <?php echo  ($arr['vrSangria'] ? $arr['vrSangria'] : "0.00") ?></b></td>
		</tr>
	</table>
</body>
</html>
