<?php

require_once "functions.php";

logincheck();

if (autorization(57) == false)
{
    ?>
    <SCRIPT>
      document.location = "?sec=erro&sub=2";
    </SCRIPT>
    <?
    die;
}
?>
<div class="container">
    <br/>
    <div class="col-md-12">
        <h2>Voucher</h2>
        <hr>
    </div>
    <div id="filter-panel">
        <div class="panel panel-default">
            <div class="panel-body">
                <div class="form-group col-md-6 col-md-offset-2">
                    <div class="input-group">
                        <div class="input-group-addon">De:</div>
                        <input type="text" name="datepicker" id="de" class="form-control data"/>
                        <div class="input-group-addon">Até:</div>
                        <input type="text" name="datepicker" id="ate" class="form-control data"/>
                    </div>
                </div>
                <div class="form-group col-md-2">
                    <a class="btn btn-primary" onclick="getData()">
                        <span class="glyphicon glyphicon-search"></span> Buscar
                    </a>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="panel" id="conteudo-empty" hidden>
                <div class="alert alert-warning col-md-10 col-md-offset-1" role="alert">
                    <h4 class="text-center">Nenhum resultado foi encontrado para o periodo selecionado!</h4>
                </div>
            </div>
            <div class="panel" id="conteudo" hidden>
                <div class="panel panel-body">
                    <table id="dtVendasClientes" width="100%" class="display table table-striped table-bordered" cellspacing="0" cellpadding="3" >
                        <thead>
                        <tr bgcolor="#2A98D3">
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Número voucher</b></span></th>
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Data</b></span></th>
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Caixa</b></span></th>
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Operador</b></span></th>
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Autorizador</b></span></th>
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Status</b></span></th>
                            <th><span style="color: #ffffff; font-family: Arial; font-size: 0.82em;"><b>Valor</b></span></th>
                        </tr>
                        </thead>
                        <tbody id="relTable"></tbody>
                        <tfoot>
                        <tr>
                            <td colspan="7" class="text-right">
                                <b> R$ <span id="vrTotal"></span></b>
                            </td>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        <div class="modal-loader"></div>
    </div>
</div>
<script src="js/jquery-2.1.4.js"></script>
<script src="js/bootstrap.min.js"></script>
<style>
    .dataTables_wrapper .dt-buttons {
        float:none;
        text-align:right;
        margin-bottom: 6px;
    }

</style>
<script>
  $(document).ready(function(){
    $("#conteudo-empty").hide();
    $("[name='datepicker']").change(function () {
    });
    setDateFields();
  });

  function initDataTable() {
    $('#dtVendasClientes').DataTable({
      "searching": false,
      "paging": false,
      "info": false,
      "destroy": true,
      "dom": 'Bfrtip',
      "buttons": ['excel', 'copy', 'print']
    });
  }

  function getData() {
    $('#relTable').empty();
    $("#conteudo").hide();
      data = {
        action: 'voucher',
        dataInicial: $('#de').val(),
        dataFinal: $('#ate').val(),
      };

      $.post('relatorios/resources/php/relatorioVendas.php', data, function(response) {

        if(response) {
            var linha = '';
            var valorTotal = 0.;

            for (var x = 0; x < response.length; x++) {
                var it = response[x];
                linha += '<tr>';
                linha += '<td>' + it['idVaucher'] + it['idAbertura'].padStart(6, "0") + '</td>';
                linha += '<td>' + it['dtEmissao'] + '</td>';
                linha += '<td>' + it['idCaixa'] + '</td>';
                linha += '<td>' + it['stOperador'] + '</td>';
                linha += '<td>' + it['stAutorizador'] + '</td>';
                linha += '<td>' + it['flLiquidado'] + '</td>';
                linha += '<td>' + it['vrVaucher'] + '</td>';
                linha += '</tr>';
                valorTotal += parseFloat(it['vrVaucher']);
            }
            $('#vrTotal').text(valorTotal.toFixed(2));
            $(linha).appendTo($('#relTable'));
            $("body").removeClass("loading");
            $("#conteudo").show();
            initDataTable();
        }else{
            swal('Erro', 'Nenhum resultado foi encontrado!', 'error')
        }
      });
    }

</script>
