<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Bootstrap Admin App">
    <meta name="keywords" content="app, responsive, jquery, bootstrap, dashboard, admin">
    <link rel="icon" type="image/x-icon" href="icone-n-retaguarda.ico">

    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Nati Retaguarda') }}</title>

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">

</head>

<body>
    <div id="app" class="wrapper">
        <div class="block-center wd-xl">
            <div class="d-flex align-items-center" style="min-height: 100vh;">
                <div class="col-lg-6">
                    <div class="card-login">
                        <!-- <div class="row"> -->
                            <!-- <div class="col-lg-8 carousel-1">
                                <div>
                                    <div id="carouselExampleControls" class="carousel slide" data-ride="carousel">
                                        <div class="carousel-inner">
                                            <div class="carousel-item active">
                                                <img src="/img/faturas.png" class="d-block w-100" alt="...">
                                            </div>
                                            <div class="carousel-item">
                                                <img src="/img/pdv.png" class="d-block w-100" alt="...">
                                            </div>
                                            <div class="carousel-item">
                                                <img src="/img/autoservice.png" class="d-block w-100" alt="...">
                                            </div>
                                            <div class="carousel-item">
                                                <img src="/img/nati-st.png" class="d-block w-100" alt="...">
                                            </div>
                                            <div class="carousel-item">
                                                <img src="/img/erp.png" class="d-block w-100" alt="...">
                                            </div>
                                            <div class="carousel-item">
                                                <img src="/img/suporte.png" class="d-block w-100" alt="...">
                                            </div>
                                            <div class="carousel-item">
                                                <img src="/img/contato-new.png" class="d-block w-100" alt="...">
                                            </div>
                                        </div>
                                        <a class="carousel-control-prev" href="#carouselExampleControls" role="button" data-slide="prev">
                                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                                            <span class="sr-only">Previous</span>
                                        </a>
                                        <a class="carousel-control-next" href="#carouselExampleControls" role="button" data-slide="next">
                                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                                            <span class="sr-only">Next</span>
                                        </a>
                                    </div>
                                </div>
                            </div> -->
                            <div class="col-lg-12">
                                <div class="card-header-login text-center">
                                    <a href="#">
                                        <img class="block-center rounded img-fluid mt-4" style="width: 150px;" src="/img/LOGO_MOBYO_PRETA.png" alt="Image">
                                    </a>
                                </div>
                                <div class="card-body">
                                    <p class="text-center py-2">Faça o login para continuar.</p>
                                    <form class="mb-3" id="loginForm" method="POST" action="{{ route('login') }}" novalidate>
                                        @csrf
                                        <div class="form-group">
                                            <div class="input-group with-focus">
                                                <input class="form-control {{ $errors->has('username') ? ' has-error' : '' }} border-right-0" id="username" type="text" value="{{ old('username') }}" name="username" placeholder="Usuário" autofocus autocomplete="off" required>
                                                <div class="input-group-append">
                                                    <span id="appenduser" class="input-group-text text-muted bg-transparent {{ $errors->has('username') ? ' has-error' : '' }} border-left-0">
                                                        <em class="fa fa-user" aria-hidden="true"></em>
                                                    </span>
                                                </div>
                                            </div>
                                            @if ($errors->has('username'))
                                            <span class="help-block-login">
                                                Usuário é requerido
                                            </span>
                                            @endif
                                        </div>
                                        <div class="form-group ">
                                            <div class="input-group with-focus">
                                                <input class="form-control {{ $errors->has('password') ? ' has-error' : '' }}  border-right-0" name="password" maxlength="8" type="password" placeholder="Senha" id="password" required>
                                                <div class="input-group-append">
                                                    <span class="input-group-text text-muted bg-transparent {{ $errors->has('password') ? ' has-error' : '' }} border-left-0" id="btngroup">
                                                        <em class="fa fa-lock"></em>
                                                    </span>
                                                </div>
                                            </div>
                                            @if ($errors->has('password'))
                                            <span class="help-block-login">
                                                Senha é requerido
                                            </span>
                                            @endif
                                        </div>
                                        @if($errors->has('user_pswd_not_found'))
                                        <div class="alert-danger text-center p-2" style="font-size: 13px; ">Usuário ou Senha inválida</div>
                                        @endif
                                        <div class="clearfix">
                                            <div class="checkbox c-checkbox float-left mt-0">

                                            </div>
                                            <div class="float-right">
                                            </div>
                                        </div>
                                        <button class="btn btn-block btn-primary mt-2" type="submit">Login</button>
                                    </form>
                                </div>
                                <div>
                                    <div class="col-lg-12 text-center">
                                        <a class="nati" href="https://www.facebook.com/profile.php?id=61568287716642" target="_blank">
                                            <i class="fab fa-facebook fa-2x mr-2"></i>
                                        </a>
                                        <a class="nati" href="https://www.instagram.com/mobyo_" target="_blank">
                                            <i class="fab fa-instagram fa-2x mr-2"></i>
                                        </a>
                                        <a class="nati" href="https://www.linkedin.com/company/mobyooficial/about/?viewAsMember=true" target="_blank"><i class="fab fa-linkedin fa-2x mr-2"></i>
                                        </a>
                                    </div>
                                </div>
                                <div class="p-3 text-center">
                                    <span class="">&copy;</span>
                                    <span>{{ now()->year }}</span>
                                    <span class="">-</span>
                                    <span>Mobyo</span>
                                    <br>
                                    <span>Mobyo Aceleradora de Negócios e Tecnologia Ltda</span>
                                </div>
                            </div>
                        <!-- </div> -->
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="{{ asset('js/manifest.js') }}"></script>
    <script src="{{ asset('js/vendor.js') }}"></script>
    <script src="{{ asset('js/app.js') }}"></script>

    <script>
        $(document).ready(function() {
            console.log('ready login')

            $('#username').focusin(function() {
                $('#appenduser').addClass('focusin');
            });

            $('#username').focusout(function() {
                $('#appenduser').removeClass('focusin');
            });

            $('#password').focusin(function() {
                $('#btngroup').addClass('focusin');
            });

            $('#password').focusout(function() {
                $('#btngroup').removeClass('focusin');
            });

            $('#username').on('keypress', function(e) {
                if (e.which == 13) {
                    e.preventDefault();
                    if ($('#username').val().length >= 2) {
                        $('#password').focus();
                    } else {
                        $('#username').addClass(' has-error');
                        $('#appenduser').addClass(' has-error');
                    }
                }
            });
            $('#password').on('keyup', function(e) {
                if (e.which == 13) {
                    e.preventDefault();
                    if ($('#username').val().length < 6) {

                    }
                }
            });

        });
    </script>

    <script>
        $('.carousel').carousel({
            interval: 4000,
            autoplay: true,
            loop: true,
        })
    </script>


</body>

</html>