<?php

/** Usado pelo nati antiog */


use App\Http\Controllers\CustomersController;
use App\Http\Controllers\EmitentesController;
use App\Http\Controllers\Financeiro\GruposController;
use App\Http\Controllers\InvoicesController;
use App\Http\Controllers\LogsController;

Route::group(['middleware' => ['api'], 'prefix' => 'v1'], function () {
    Route::post('gerenciador/{id}/close', 'ManagerController@close');
});

/** Global */
Route::group(['middleware' => ['api'], 'prefix' => 'v1'], function (){
   Route::get('/customers/search', [CustomersController::class, 'filter']);
});



/** Nati  */
Route::group(['middleware' => ['auth:api'], 'prefix' => 'v1'], function () {
    //Store
    Route::get('store', 'MasterController@index');
    Route::put('store/{id}', 'MasterController@update');
    Route::get('store/info', 'MasterController@info');
    Route::put('store/update/sub-account-token/{id}/{dealer}', 'MasterController@updateSubAccountToken');

    //Cliente payment provider
    Route::get('payment-provider/getCompany', 'PaymentProviderController@getCompany');
    Route::post('payment-provider/storeCompany', 'PaymentProviderController@storeCompany');
    // Route::get('payment-provider/subscription', 'PaymentProviderController@getSubscription');
    Route::get('payment-provider/subscription/search', 'PaymentProviderController@searchSubscription');
    Route::post('payment-provider/subscription/activate/{id}', 'PaymentProviderController@activateSubscription');
//    Route::get('payment-provider/invoices/', 'PaymentProviderController@getInvoices');

    /* Categorias */
    Route::get('categorias-all', 'CategoriasController@getAll');
    Route::post('categorias/{id}/sub-categorias', 'CategoriasController@addSubcategoria');
    Route::get('categorias/{id}/sub-categorias', 'CategoriasController@getSubcategoria');
    Route::post('categorias/{id}/sub-categorias/remove', 'CategoriasController@deleteSubcategoria');
    Route::put('sub-category/moved/{id}/{id_category}', 'SubCategoriasController@transfer');
    Route::put('sub-category/edit/{id}/{id_category}', 'SubCategoriasController@update');

    //Perguntas
    Route::get('perguntas', 'PerguntasController@getAll');
    Route::post('perguntas/create', 'PerguntasController@create');
    Route::get('perguntas/filter/{data}', 'PerguntasController@filter');
    Route::get('perguntas/{id}/show', 'PerguntasController@show');
    Route::delete('perguntas/{id}', 'PerguntasController@delete');
    Route::patch('perguntas/update/{id}', 'PerguntasController@update');

    //Observacoes
    Route::get('observacoes', 'RespostaObservacoesController@getAll');
    Route::post('observacoes/new', 'RespostaObservacoesController@store');
    Route::put('observacoes/{id}/edit', 'RespostaObservacoesController@update');
    Route::delete('observacoes/{id}/delete', 'RespostaObservacoesController@destroy');
    Route::get('observacoes/filter/{data}', 'RespostaObservacoesController@filter');
    Route::get('observacoes/{id}/show', 'RespostaObservacoesController@show');
    /* Produtos */
    Route::get('produtos/verify-code/{id}', 'ProductsController@verifyCode');
    Route::get('produtos/filter/{data}', 'ProductsController@filter');
    Route::put('produtos/active/{id}', 'ProductsController@active');
    Route::post('produtos/active-stock/{id}', 'ProductsController@activeStock');
    Route::get('produtos/ficha-tecnica/filter', 'ProductsController@getPrintConfig');
    Route::get('produtos/group/{id}', 'ProductsController@getByGroup');
    Route::get('produtos/count', 'ProductsController@count');
    Route::get('product/next-code', 'ProductsController@nextcode');
    Route::get('produtos/ajuste-preco', 'ProductsController@ajustePreco');
    Route::post('produtos/ajustar-preco', 'ProductsController@ajustarPreco');
    Route::get('produtos/sample','ProductsController@download');
    Route::post('produtos/import', 'ProductsController@import');
    Route::get('produtos/export', 'ProductsController@export');
    Route::get('product/config', 'ConfigController@index');
    Route::post('product/config', 'ConfigController@config');
    Route::post('product/move-category/{category}/{sub_category}', 'ProductsController@');
    Route::post('product/move-sector/{sector}', 'ProductsController@moveSector');
    Route::post('produtos/update-tax', 'ProductsController@updateTaxDatas');
    Route::post('product/update-tax/{id}', 'ProductsController@updateTaxData');
    Route::get('products/find/{param}', 'ProductsController@find');
    Route::get('products/find-by-code/{param}', 'ProductsController@findByCod');
    Route::get('products/get-by-category/{idCategory}', 'ProductsController@getProductsByCategory');
    Route::get('products/get-stock-balance-by-category/{idCategory}', 'ProductsController@getProductsWithBalanceStockByCategory');
    Route::get('products/canCreate', 'ProductsController@canCreateProducts');

    Route::post('imprimir-gondula/{id}/{impressora}', 'ImprimirEtiqueta@imprimir');
    Route::get('tabela-nutricional/{produto}', 'TabelaNutricionalController@show');
    Route::get('revisaofiscal', 'ProductsController@painelAliquotas');
    Route::get('setores-all', 'SectorsController@getAll');
    Route::get('ncm/get', 'NcmController@all');
    Route::get('ncm/get/{ncm}', 'NcmController@get');
    Route::get('ncm/find/{text}', 'NcmController@find');
    Route::get('cest/{ncm}', 'CestsController@show');
    Route::put('cest/update-products-without-cest', 'CestsController@updateProductsWithoutCEST');

    Route::get('keys-available', 'KeysController@getKeyAvailable');

    Route::get('cliente/next-id', 'CustomersController@getNextId');
    Route::get('cliente/filter', 'CustomersController@filter');
    Route::get('clientes/count', 'CustomersController@count');
    Route::get('clientes/find/{param}', 'CustomersController@find');
    Route::get('clientes/getOnlyCustomer/{param}', 'CustomersController@getOnlyCustomer');

    Route::get('phoneId/{id}', 'CustomersController@getPhoneById');
    Route::get('key/componentes-disponiveis', 'KeysController@getAvailableComponents');
    Route::post('key/import', 'KeysController@import');


    Route::get('suppliers-all', 'SuppliersController@getAll');
    Route::get('suppliers/count', 'SuppliersController@count');

    Route::get('gerenciador/available-methods-payments', 'ManagerController@getAvailableMethodsPayments');
    Route::patch('gerenciador/change-payment-method', 'ManagerController@updatePaymentMethod');
    Route::get('gerenciador/numbers-pdv', 'ManagerController@getNumbersPDV');
    Route::get('gerenciador', 'ManagerController@index');
    Route::get('gerenciador/closed', 'ManagerController@getAllClosed');
    Route::get('gerenciador/{idAbertura}/payments/{idFormaPagamento}', 'ManagerController@payments');
    Route::get('gerenciador/detalhes/{id}', 'ManagerController@details');
    Route::put('gerenciador/{id}', 'ManagerController@edit');
    Route::get('gerenciador/details/{id}', 'ManagerController@getDadosCaixa');
    Route::get('gerenciador/{id}', 'ManagerController@show');
    Route::get('gerenciador/detalhes/{id}', 'ManagerController@details');
    Route::put('gerenciador/{id}', 'ManagerController@edit');
    Route::get('gerenciador/{id}/sangrias', 'ManagerController@sangrias');
    Route::get('gerenciador/{id}/suprimentos', 'ManagerController@suprimentos');
    Route::get('gerenciador/{id}/despesas', 'ManagerController@despesas');
    Route::get('gerenciador/{id}/vendas-pendura', 'ManagerController@vendasPendura');
    Route::get('gerenciador/{id}/depositos', 'ManagerController@depositos');
    Route::get('gerenciador/{id}/vendas', 'ManagerController@vendas');
    Route::get('gerenciador/{id}/venda/{idVenda}', 'ManagerController@getDetalhesVenda');
    Route::get('gerenciador/{id}/vendas-pendura', 'ManagerController@vendasPendura');
    Route::get('gerenciador/details/{id}', 'ManagerController@getDadosCaixa');
    Route::get('gerenciador/{idAbertura}/vendas/{idVenda}', 'SalesController@getVenda');
    Route::patch('gerenciador/{idAbertura}/reopen/', 'ManagerController@reOpen');
    Route::get('gerenciador/{idAbertura}/cancelamentos', 'ManagerController@getCancelamentos');
    Route::delete('gerenciador/{idAbertura}/delete', 'ManagerController@delete');
    Route::get('forma-pagamento', 'ReceiptFormTempController@show');
    Route::get('cepId/{cep}', 'CEPsController@getCepById');
    Route::get('cep2/{cep}', 'CEPsController@apiGetCep');
    Route::get('cepOnline/{cep}', 'CEPsController@apiOnlineGetCep');
    Route::get('permissoes', 'ProfilesController@permissions');
    Route::get('usuario/next-id', 'UsersController@nextId');
    Route::post('usuario/change-pwd/{id}/{data}', 'UsersController@changePwd');
    Route::post('usuario/store-card/{idUser}/{codCard}', 'UsersController@storeCard');
    Route::get('usuario/cashiers', 'UsersController@getCashiers');
    Route::get('usuario/find/{param}', 'UsersController@find');

    Route::get('/pre-order', 'OrderTabController@getAll');
    Route::get('/pre-order/{tabId}', 'OrderTabController@show');
    Route::get('/pre-order/items/{tabId}', 'OrderTabController@items');
    Route::delete('/pre-order/{tabId}', 'OrderTabController@destroy');
    Route::put('/pre-order/block/{tabId}', 'OrderTabController@block');
    Route::put('/pre-order/unblock/{tabId}', 'OrderTabController@unblock');

//Reports
    Route::get('sales', 'SalesController@get');
    Route::get('sales-report', 'SalesController@getSalesReport');
    Route::get('sales-items-report', 'SalesController@getSalesItemsReport');
    Route::get('commissions', 'ReportsController@getCommission');
    Route::get('conta/invoices', [InvoicesController::class, 'index']);
    Route::get('logs', [LogsController::class, 'index']);
    Route::get('pedidos-delivery', 'ReportsController@getOrdersDelivery');
    Route::get('relatorios/fechamento-periodo', 'ReportFechamentoCaixaController@getReport');
    Route::get('relatorios/estoque/group-by-product', 'ReportsController@getStockGroupByProduct');
    Route::get('relatorios/estoque/kardex', 'ReportsController@getKardex');
//Mobyo
    // Route::get('mobyo-config', 'MobyoConfigController@index');

//TXT BALANÇA
    Route::get('exportar-balanca', 'BalanceProductsController@getProductsBalance');
    Route::get('exportar-balanca/filter', 'BalanceProductsController@filterProducts');
    Route::get('exportar-balanca/get-all', 'BalanceProductsController@getAllProductsBalance');
    Route::get('exportar-balanca/count', 'BalanceProductsController@countProductsBalance');
    Route::post('exportar-balanca/update', 'BalanceProductsController@updateProductsBalance');
    Route::post('exportar-balanca/gerar-arquivo', 'BalanceProductsController@generateFiles');
    Route::get('exportar-balanca/baixar-arquivo/{file}', 'BalanceProductsController@downloadFiles');


//Services
    Route::put('services/minimum-stock/set-minimum-stock', 'SaldoEstoqueController@updateMinimumStock');
    Route::put('services/set-stock-multiples-products', 'ProductsController@setStockMultiplesProducts');
    Route::get('services/adjust-stock/get-stocks', 'StocksController@getStocks');
    Route::get('services/adjust-stock/filter-products', 'StocksController@filterProducts');
    Route::post('services/adjust-stock/update', 'StocksController@adjust');
    Route::get('services/adjust-products-tax/get-by-category', 'AdjustProductsTaxController@getProductsTaxByCategory');
    Route::get('services/adjust-products-tax/get-by-filter', 'AdjustProductsTaxController@getProductsTaxByFilter');
    Route::post('services/adjust-products-tax/update', 'AdjustProductsTaxController@updateProductsTax');
    Route::post('services/transfer', 'StocksController@transferir');

//estoque
    Route::get('stock/product-by-stock', 'StocksController@productsByStock');

//Version
    Route::get('version', 'VersionController@getVersionNumber');

    //DASHBOARD
    Route::get('dashboard/sales-by-month', 'DashboardController@getSalesByMonth');
    Route::get('dashboard/top-products', 'DashboardController@getTopProducts');
    Route::get('dashboard/statistics-by-month', 'DashboardController@getStatisticsByMonth');
    Route::get('dashboard/sales-by-day', 'DashboardController@getSalesByDay');
    Route::get('dashboard/sales-by-time', 'DashboardController@getSalesByTime');


    Route::resources([
        'produtos' => 'ProductsController',
        'categorias' => 'CategoriasController',
        'stock-balance' => 'StockBalancesController',
        'aliquotas' => 'AliquotasController',
        'clientes' => 'CustomersController',
        'entregadores' => 'EntregadoresController',
        'ficha-tecnica' => 'FichaTecnicaController',
        'formas-pagamento' => 'FormaPagamentoController',
        'impressoras' => 'ImpressoraController',
        'keys' => 'KeysController',
        'localizacoes' => 'LocalizacoesController',
        'medidas' => 'MeasuresController',
        'micro-terminais' => 'MicroTerminalController',
        'pontos-delivery' => 'PontoDeliveryController',
        'setores' => 'SectorsController',
        'stocks' => 'StocksController',
        'suppliers' => 'SuppliersController',
        'tipos-pagamento' => 'TipoFormaPagamentoController',
        'turnos' => 'TurnosController',
        'sat-equipamentos' => 'SatEquipamentosController',
        'config' => 'ConfigController',
        'ceps' => 'CEPsController',
        'usuarios' => 'UsersController',
        'perfis' => 'ProfilesController',
        'desenfila-configs' => 'DesenfilaConfigsController',
        'emitente' =>  'EmitentesController'
    ]);
});

//ROTAS DE NCM
Route::get('ncm/get/{ncm}', 'NcmController@get');
Route::get('ncm/find/{text}', 'NcmController@find');
Route::get('ncm/findOld/{text}', 'NcmController@findOldVersion');


//Ping rota de teste de conectividade
Route::group(['middleware' => []], function () {
    Route::get('ping', function () {
        return response()->json(['message' => 'pong'], 200);
    });
});

// JWT PROTECT
Route::group(['namespace' => 'Auth', 'prefix' => 'auth'], function ($router) {
    Route::post('login', 'JwtLoginController@login');
    Route::post('logout', 'JwtLoginController@logout');
    Route::post('refresh', 'JwtLoginController@refresh');
    Route::post('me', 'JwtLoginController@me');
});

//Commission.vue

Route::group(['middleware' => ['auth:api'], 'prefix' => 'v1'], function () {
    Route::get('usuario/me', 'UsersController@me');
});

/*------------------------------ Financeiro -----------------------------------------------------------*/
Route::group(['middleware' => ['api'], 'prefix' => 'financeiro/v1', 'namespace' => 'Financeiro'], function () {
    Route::resources([
//        'bandeiras' => 'BandeirasController',
        'centro-custo' => 'CentroDeCustosController',
        'grupos'            => 'GruposController',
//        'despesas' => 'DespesasController',
//        'conta-bancaria' => 'ContaBancariasController',
//        'sub-grupos' => 'SubGruposController',
//        'pagamentos' => 'PagamentosController',
//        'contas' => 'ContasController'
    ], ['except' => ['edit', 'create']]);
//
//    Route::post('despesas/pending', 'DespesasController@pending');
//    Route::post('despesas/delete', 'DespesasController@delete');
    //DataTables
//    Route::get('bandeiras-table', 'BandeirasController@dataTable');
//    Route::get('centrocusto-table', 'CentroDeCustosController@dataTable');
//    Route::get('contabancaria-table', 'ContaBancariasController@datatable');
//    Route::get('grupo-table', 'GruposController@datatable');
//    Route::get('subgrupo-table', 'SubGruposController@datatable');
//    Route::get('pagamentos-table', 'PagamentosController@dataTable');
//    Route::get('contas-table', 'ContasController@dataTable');

    Route::get('tipos-pagamento', 'TiposPagamentoController@index');
});


/*--------------------------------------------------------------------------------------------------------------------*/
/*--------------------------------------------------- Financeiro -----------------------------------------------------*/
/*--------------------------------------------------------------------------------------------------------------------*/
Route::group(['middleware' => ['api'], 'prefix' => 'v1/financeiro', 'namespace' => 'Financeiro'], function () {

    Route::resources([
        'lancamentos'       => 'LancamentosController',
        'contasapagar'      => 'ContasAPagarController',
        'entradas'          => 'ContasReceberController',
        'contas-bancarias'  => 'ContaBancariasController',
        'centro-custo'      => 'CentroDeCustosController',
        'grupos'            => 'GruposController',
        'contas'            => 'ContasController'
    ], ['except' => ['edit', 'cerate']]);

    Route::post('grupos/{grupo}/add-subgrupo', [GruposController::class, 'addSubgrupo']);
    Route::delete('grupos/{grupo}/delete/{sub}', [GruposController::class, 'removeSubgrupo']);

    Route::get('contas/{idConta}/sub-grupos', 'ContasController@getSubGrupos');

    Route::post('contasapagar/fromexpense', 'ContasAPagarController@createFromExpense');
    Route::post('contasapagar/getInterval', 'ContasAPagarController@getLancamento');
    Route::get('contasapagar/{idContasPagar}/{idFornecedor}', 'ContasAPagarController@view');
    Route::put('contasapagar/setbaixa/{idContasPagar}/{idFornecedor}', 'ContasAPagarController@setBaixa');
    Route::put('contasapagar/{idContasPagar}/{idFornecedor}', 'ContasAPagarController@atualizar');
    Route::put('contasapagar/estorno/{idContasPagar}/{idFornecedor}', 'ContasAPagarController@estorno');
    Route::post('contasapagar/selectBaixa', 'ContasAPagarController@selectBaixa');

    Route::post('lancamentos/getInterval', 'LancamentosController@getLancamento');
    Route::get('lancamentos/{idContasReceber}/{idCliente}', 'LancamentosController@view');
    Route::put('lancamentos/{idContasReceber}/{idCliente}', 'LancamentosController@atualizar');
    Route::delete('lancamentos/{idContasReceber}/{idCliente}', 'LancamentosController@delete');
    Route::post('lancamentos/selectBaixa', 'LancamentosController@selectBaixa');

    Route::put('estorno/{idContasReceber}/{idCliente}', 'LancamentosController@estorno');
    Route::put('setbaixa/{idContasReceber}/{idCliente}', 'LancamentosController@setBaixa');
    Route::get('find/{text}', 'LancamentosController@find');
});

/*------------------------------ Delivery -----------------------------------------------------------*/
Route::group(['middleware' => [], 'prefix' => '/v1', 'namespace' => 'Delivery'], function () {
    Route::post('ifood/orders', 'MobyoIntegrationController@store');
});
Route::group(['middleware' => [], 'prefix' => 'delivery/v1', 'namespace' => 'Delivery'], function () {
    //Route::post('ifood/orders', 'MobyoIntegrationController@store');
    Route::post('request-cfe/{id}', 'OrderController@requestCfe');
    Route::get('request-cfe/{id}', 'OrderController@getCfe');
    Route::post('orders/concluded/{id}', 'OrderController@concluded');

    Route::resources([
        'orders' => 'OrderController',
        'pedidos' => 'PedidosController'
    ]);
});

Route::group(['middleware' => ['auth:api'], 'prefix' => 'delivery/v1', 'namespace' => 'Delivery'], function () {
    Route::middleware('auth:api')->post('customers', 'CustomersController@store');
});


Route::group(['middleware' => ['auth:api'], 'prefix' => 'v1', 'namespace' => 'Delivery'], function () {
    Route::resources([
//        'ifood/orders' => 'MobyoIntegrationController',
        'pedidos' => 'PedidosController',
    ]);

    Route::get('monitor-preparo/{id}', 'PainelPreparoController@index');

    Route::post('imprimir-cupom/{idAtendimento}', 'MobyoIntegrationController@printCoupon');
    Route::post('imprimir-cupom-remoto/{idAtendimento}', 'MobyoIntegrationController@printRemoteCoupon');


    Route::get('orders/pending', 'OrderController@getPendingOrders');
    Route::get('orders/{id}', 'OrderController@show');
    Route::get('orders/new', 'OrderController@create');
});

// ROUTES TESTS

//dashboard - vendas
Route::get('dashboard/sales-by-month', 'DashboardController@getSalesByMonth');
Route::get('dashboard/sales-by-day', 'DashboardController@getSalesByDay');
Route::get('dashboard/top-products', 'DashboardController@getTopProducts');
Route::get('dashboard/statistics-by-month', 'DashboardController@getStatisticsByMonth');
Route::get('dashboard/sales-comparative', 'DashboardController@getSalesComparative');
Route::get('dashboard/cancelled-sales', 'DashboardController@getCancelledSales');
Route::get('dashboard/sales-by-segment', 'DashboardController@getSalesBySegment');
Route::get('dashboard/sales-by-time', 'DashboardController@getSalesByTime');

Route::get('relatorios/fechamento-periodo', 'ReportFechamentoCaixaController@getReport');


    //KDS
    Route::post('/kds/new-orders', 'KDSController@new'); //-> to-do criar middleware
    Route::post('/kds/new-orders-cancelled', 'KDSController@cancel');
    Route::post('/kds/tab-done', 'KDSController@tabDone');
    Route::post('/kds/item-done', 'KDSController@itemDone');
    Route::get('/kds/all', 'KDSController@getAll');
    Route::post('/kds/displays/create-or-update', 'KdsDisplayController@createOrUpdate');
    Route::get('/kds/displays/{deviceId}', 'KDSDisplayController@getDevice');

    //WS
    Route::get('/ws/initialize', 'WsController@init');
/**
 * GET /tickets/12/messages - Retrieves list of messages for ticket #12
 * GET /tickets/12/messages/5 - Retrieves message #5 for ticket #12
 * POST /tickets/12/messages - Creates a new message in ticket #12
 * PUT /tickets/12/messages/5 - Updates message #5 for ticket #12
 * PATCH /tickets/12/messages/5 - Partially updates message #5 for ticket #12
 * DELETE /tickets/12/messages/5 - Deletes message #5 for ticket #12
 */

require __DIR__ . '/api/nati.php';
require __DIR__ . '/api/financeiro.php';
require __DIR__ . '/api/delivery.php';
