<?php

use http\Client\Response;
use Illuminate\Support\Facades\Auth;

Auth::routes([
    'register' => false,
    'password' => false,
    'reset' => false,
    'verify' => false
]);

Route::group(['namespace' => 'auth'], function () {
    Route::get('/logout', 'LoginController@logout');
});

Route::group(['middleware' => ['auth']], function () {
    Route::get('/app{any}', 'SpaController@index')->where('any', '.*');
});

Route::group(['middleware' => ['auth'], 'namespace' => 'Nati'], function () {

    Route::redirect('/', '/app/dashboard');

    Route::get('/servicos', function () {
        return redirect('nati/?sec=servicos');
    });

    Route::get('/tesouraria', function () {
        return redirect('nati/?sec=presidente');
    });

    Route::get('/customizacoes', function () {
        return redirect('nati/?sec=custom');
    });

    Route::get('/relatorios', function () {
        return redirect('nati/index.php?sec=relatorios');
    })->name('relatorios');
});

Route::get('/new/delivery', function () {
    return view('delivery.dashboard');
});

Route::group(['prefix'=> '/new/financeiro'], function (){
    Route::get('/', function(){
        return view('financeiro.dashboard');
    });
    Route::get('/contas-bancarias', function (){
        return view('financeiro.contasBancarias');
    });
    Route::get('/contas', function (){
       return view('financeiro.contas');
    });

    Route::get('/centro-custos', function (){
        return view('financeiro.CentroCusto');
    });
    Route::get('/grupo', function (){
        return view('financeiro.Grupo');
    });
    Route::get('/grupo/{grupo}/show', function (){
        return view('financeiro.Grupo.Detalhe');
    });

    Route::get('/entradas', function(){
        return view('financeiro.Entradas');
    });
    Route::get('/saidas', function(){
        return view('financeiro.Saidas');
    });
});

Route::get('produtos/export', 'ProductsController@export');
Route::get('produtos/export-mobyo', 'ProductsController@exportForMobyo');
Route::get('produtos/export-integration', 'ProductsController@exportForIntegration');
Route::get('produtos/export-linx', 'ProductsController@exportForLinx');

Route::get('produtos/sample','ProductsController@download');

Route::get('reports/commission', 'MyReportController@commission');


require __DIR__ . '/web/nati.php';
require __DIR__ . '/web/financeiro.php';
require __DIR__ . '/web/delivery.php';
