<?php

namespace App\Entities\Financeiro;

use App\Entities\Supplier;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class ContaAPagar extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'fin_ContasPagar';
    protected $primaryKey = ['idContasPagar','idFornecedor'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idContasPagar',
        'idFornecedor',
        'idTipoConta',
        'idCentroCusto',
        'idMovimentacao',
        'idAbertura',
        'dtLancamento',
        'dtVencimento',
        'dtPagamento',
        'nrParcela',
        'nrTotalParcelas',
        'vrDocumento',
        'vrJuros',
        'flJuros',
        'vrPago',
        'flPago',
        'flAtivo',
        'stOperador',
        'stObservacao',
        'stDocumento',
        'stTipoBaixa',
        'stTipoJuros',
        'stObservacaoBaixa',
        'vrDescontoLancamento',
        'idContaBancaria',
        'idTipoPagamento',
        'idConta',
        'idCheque',
        'idContasPagarRecorrente',
        'dtAlteracao',
        'flAutorizado',
        'nrPrioridade',
        'dtPrevisao',
        'vrEncargos',
        'vrOutros',
        'vrDescontos',
        'tipoPagamento'
    ];

    protected $hidden = [
        'suplliers',
        'contas',
        'subgrupo',
    ];

    protected $maps = [
        'nome_fornecedor' => 'suplliers.name',
//        'email_cliente' => 'clientes.stEmail',
        'conta' => 'contas.stConta',
        'idSub_grupo' => 'subgrupo.idTipoConta',
        'sub_grupo' => 'subgrupo.stTipoConta',
        'grupo' =>  'subgrupo.grupo.stCategoriaConta',
        'idGrupo' => 'subgrupo.grupo.idCategoriaConta',
        'pagamento' => 'tipoPagamento.stTipoPagamento',
        'cnpj' => 'suplliers.cnpj'
    ];

    protected $appends = [
        'nome_fornecedor',
//        'email_cliente',
        'conta',
        'idSub_grupo',
        'sub_grupo',
        'idGrupo',
        'grupo',
        'pagamento',
        'cnpj'
    ];


    function suplliers()
    {
        return $this->belongsTo(Supplier::class ,'idFornecedor');
    }

    function contas()
    {
        return $this->belongsTo(Conta::class,'idConta');
    }

    public function subgrupo()
    {
        return $this->belongsTo(SubGrupo::class, 'idTipoConta');
    }

    public function tipoPagamento()
    {
        return $this->belongsTo(TipoPagamento::class, 'idTipoPagamento');
    }

}
