<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class OrderDevice extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'mt_Microterminais';
    protected $primaryKey = 'idMicroTerminal';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idMicroTerminal',
        'stMicroTerminal',
        'stTipo',
        'nrPorta',
        'nrTeclas',
        'flLeitor',
        'flOperador',
        'stBalanca',
        'flModoCheckOut',
        'idCaixa',
        'idOrigem',
        'idDestino',
        'stMarcaPrint',
        'flPrint',
        'stTipoPorta',
        'flPrintAll',
        'nrCOMDisplay',
        'stDisplay',
        'flAtivo',
        'dtAlteracao',
        'nrTabelaPreco',
        'sync',
    ];
}
