<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class Resposta.
 *
 * @package namespace App\Entities\\Nati;
 */
class Resposta extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = "prd_respostas";
    protected $primaryKey = 'idResposta';
    public $incrementing = true;
    public $timestamps = false;
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'idPergunta',
        'idTipoResposta',
        'idRespostaProduto',
        'idRespostaObservacao',
        'dtAlteracao',
        'flAtivo',
        'nrOrdem'
    ];

    protected  $casts = [
        'flAtivo' => 'boolean',
        'idTipoResposta' => 'integer',
        'nrOrdem' => 'integer'
    ];


}
