<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

/**
 * Class Profile.
 *
 * @package namespace App\Entities;
 */
class Profile extends Model implements Transformable
{
    use TransformableTrait;
//

    protected $table = 'op_Perfis';
    protected $primaryKey = 'idPerfil';
    public $timestamps = false;
    public $incrementing = false;
    CONST UPDATED_AT = 'dtAlteracao';

    protected $fillable = [
        'idPerfil',
        'stDescricao',
        'stIds',
        'dtAlteracao'
    ];

    protected $appends=[
        'quantity'
    ];

    public function getQuantityAttribute()
    {
        return substr_count($this->stIds, ',') + 1;
    }

    public function usuarios()
    {
        return $this->hasMany(User::class, 'idPerfil');
    }

    public function generateTags(): array
    {
        return [
            'config'
        ];
    }
}
