<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class TypePaymentMethod extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'cx_TiposFormaPagamento';
    protected $primaryKey = 'idTipoForma';
    public $timestamps = false;

    protected $fillable = [
        'idTipoForma',
        'stTipo',
        'dtAlteracao',
        'flAtivo'
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
    ];

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'idTipo', 'idTipoForma' );
    }


}
