<?php

namespace App\Http\Controllers;

use App\Entities\Emitente;
use Illuminate\Http\Request;

use App\Http\Requests;
use Prettus\Validator\Contracts\ValidatorInterface;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\EmitenteCreateRequest;
use App\Http\Requests\EmitenteUpdateRequest;
use App\Repositories\EmitenteRepository;
use App\Validators\EmitenteValidator;

/**
 * Class EmitentesController.
 *
 * @package namespace App\Http\Controllers;
 */
class EmitentesController extends Controller
{
    /**
     * @var EmitenteRepository
     */
    protected $repository;

    /**
     * @var EmitenteValidator
     */
    protected $validator;

    /**
     * EmitentesController constructor.
     *
     * @param EmitenteRepository $repository
     * @param EmitenteValidator $validator
     */
    public function __construct(EmitenteRepository $repository, EmitenteValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function index()
    {
        $emitente = Emitente::first();

        return response()->json($emitente);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param EmitenteCreateRequest $request
     *
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \Prettus\Validator\Exceptions\ValidatorException
     */
    public function store(EmitenteCreateRequest $request)
    {
        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_CREATE);
            $request['flAtivo'] = true;
            $emitente = $this->repository->create($request->all());

            $response = [
                'message' => 'Emitente created.',
                'data' => $emitente->toArray(),
            ];

            return response()->json($response);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ]);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function show($id)
    {
        $emitente = $this->repository->find($id);

        return response()->json([
            'data' => $emitente,
        ]);

    }


    /**
     * Update the specified resource in storage.
     *
     * @param EmitenteUpdateRequest $request
     * @param string $id
     *
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \Prettus\Validator\Exceptions\ValidatorException
     */
    public function update(EmitenteUpdateRequest $request, $id)
    {
        try {

            $this->validator->with($request->all())->passesOrFail(ValidatorInterface::RULE_UPDATE);

            $emitente = $this->repository->update($request->all(), $id);

            $response = [
                'message' => 'Emitente updated.',
                'data' => $emitente->toArray(),
            ];

            return response()->json($response);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ]);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function destroy($id)
    {
        $deleted = $this->repository->delete($id);

        return response()->json([
            'message' => 'Emitente deleted.',
            'deleted' => $deleted,
        ]);
    }
}
