<?php

namespace App\Http\Resources\Nati;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderTabResource extends JsonResource
{
    /**
     * @param Request $request
     * @return array
     */
    public function toArray($request)
    {
        return [
            'id' => $this->idComada,
            'valor' => $this->vrTotal,
            'items_count' => $this->items_count,
            'items' => $this->get_items()
        ];
    }

    private function get_items()
    {
        $items = array();

        foreach ($this->items as $item) {
            array_push($items,[
                "codigo" => $item->item->codigo->toArray()[0]['idCodigo'],
                "quantidade" => $item->nrQuantidade,
                "alteracao" => $this->dtAlteracao,
                "atendente" => $item->stOperador,
                "nome" => $item->item->stProduto,
                "total" => $item->vrTotal
            ]);
        }

        return $items;
    }
}
