<?php

namespace App\Listeners;

use App\Entities\PaymentMethod;
use App\Entities\TypePaymentMethod;
use App\Events\OrderCreated;
use App\Services\CliExtratoService;
use App\Services\Delivery\PrintService;
use App\Services\Delivery\SatService;
use App\Services\Sales\SalesService;
use App\Entities\Delivery\MobyoConfig;
use App\Entities\Mobyo\Integration;

class OrderCreatedListener
{

    protected $printService;
    protected $saleService;
    protected $satService;
    protected $extratoService;
    protected $integration;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(PrintService $printService, SalesService $saleService, SatService $satService, CliExtratoService $extratoService)
    {
        $this->printService = $printService;
        $this->saleService = $saleService;
        $this->satService = $satService;
        $this->extratoService = $extratoService;
    }

    /**
     * Handle the event.
     *
     * @param OrderCreated $event
     * @return void
     */
    public function handle(OrderCreated $event)
    {
        $this->integration = new Integration($event->order['engine']);

        if ($this->integration->flEmitirCupomRemoto) {
            $this->printService->printRemoteCoupon($event->order->idAtendimento, $this->integration->engine);
        }
        if ($this->integration->flEmitirCupomDelivery) {
            try {
                $this->printService->printCoupon($event->order->idAtendimento, 'mobyo', false, $this->integration);
            }catch (\Exception $exception){

            }
        }
        if ($this->integration->flSalvarVendaAutomaticamente) {
            $sale = $this->saleService->fromDelivery($event->order->idAtendimento);
            if ($sale) {
                $sale->load(['paymentsTemp', 'itens']);
                $payment = $sale->paymentsTemp()->first();
                $forma = PaymentMethod::with('tipo')->find($payment->idFormaPagamento);
                $tipo = TypePaymentMethod::find($forma->idTipo);
                if ($tipo->idTipoForma == 14 || $tipo->idTipoForma == 12) {
                    $this->extratoService->save($sale);
                }
            }
        }
        if ($this->integration->flEmitirCFEAutomaticamente) {
            try {
                $this->satService->transmite($event->order->idAtendimento);
            } catch (\Exception $e) {

            }
        }

    }

}
