<?php


namespace App\Reports;


use App\Entities\Nati\Customer;
use \koolreport\processes\Group;
use \koolreport\processes\Sort;
use \koolreport\processes\Limit;
use \koolreport\processes\CalculatedColumn;

require "../koolreport/core/autoload.php";

class Commission extends \koolreport\KoolReport
{
    use \koolreport\laravel\Friendship;
    use \koolreport\inputs\Bindable;
    use \koolreport\laravel\inputs\POSTBinding;

    protected function defaultParamValues()
    {
        return array(
            "dateRange"=>array(date("Y-m-d 00:00:00"),date("Y-m-d 23:59:59")),
            "textBox"=>"KoolReport is great",
            "select"=>"",
            "multiSelect"=>array(),
            "radioList"=>"",
            "checkBoxList"=>array(),
            "startDatePicker"=>date("Y-m-d 00:00:00"),
            "endDatePicker"=>date("Y-m-d 23:59:59"),
            "rangeSliderOne"=>array(50),
            "rangeSliderTwo"=>array(20,80),
        );
    }

    protected function bindParamsToInputs()
    {
        return array(
            "dateRange",
            "select",
            "multiSelect",
            "textBox",
            "radioList",
            "checkBoxList",
            "startDatePicker",
            "endDatePicker",
            "singleSelect2",
            "multipleSelect2",
            "singleBSelect",
            "multipleBSelect",
            "rangeSliderOne",
            "rangeSliderTwo",
        );
    }

    function setup()
    {
        $this->src("sqlsrv")
            ->query("
                DECLARE @vrTaxaServico AS DECIMAL(9,2);
                SET @vrTaxaServico =(SELECT vrTaxaServico FROM [Master]);
                DECLARE @qtdWaiters as int;
                set @qtdWaiters = (select count(distinct stAtendente) as qtdWaiters from cx_Itens_Temp);

                SELECT I.stAtendente, SUM(I.vrTotal) AS vrTotal, (SUM(I.vrTotal) * @vrTaxaServico) AS vrComissao, @vrTaxaServico AS vrTaxaServico, @qtdWaiters as qtdWaiters
                FROM
                (SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas UNION SELECT idVenda, idAbertura, vrTotal, dtData, vrAcrescimo, flAtivo FROM cx_Vendas_Temp) V
                INNER JOIN
                (SELECT * FROM cx_Itens UNION SELECT * FROM cx_Itens_Temp) I
                ON V.idAbertura = I.idAbertura AND V.idVenda = I.idVenda
                WHERE V.flAtivo = 'true' AND I.flAtivo = 'true' AND V.dtData BETWEEN '2021-03-09 00:00:00' AND '2021-03-09 23:00:00'
                GROUP BY I.stAtendente
            ")
            // ->params(array(
            //     ":dtStart"=>$this->params["dtStart"],
            //     ":dtEnd"=>$this->params["dtEnd"]
            // ))
            // ->pipe(new CalculatedColumn(array(
            //     "comissao" => "{vrComissao}*{vrTaxaServico}/{qtdWaiters}",
            // )))
            ->pipe(new Group(['by'=> 'stAtendente', 'sum'=>'vrTotal',]))
            ->pipe($this->dataStore("Commission"));
    }
}
