<?php

namespace App\Repositories;

use App\Entities\Financeiro\ContaAPagar;
use App\Validators\Financeiro\ContaAPagarValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class ContasReceberRepositoryEloquent
 * @package namespace App\Repositories;
 */
class ContasAPagarRepositoryEloquent extends BaseRepository implements ContasAPagarRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return ContaAPagar::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {
        return ContaAPagarValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
