<?php

namespace App\Repositories;

use App\Entities\Financeiro\ContasReceberView;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Validators\ContasReceberValidator;

/**
 * Class ContasReceberRepositoryEloquent
 * @package namespace App\Repositories;
 */
class ContasReceberRepositoryEloquent extends BaseRepository implements ContasReceberRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return ContasReceberView::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return ContasReceberValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
