<?php

namespace App\Services;

use Carbon\Carbon;
use App\Repositories\ContaBancariaRepository;
use Prettus\Validator\Contracts\ValidatorInterface;
use App\Validators\Financeiro\ContaBancariaValidator;

class ContaBancariaService
{
    private $repository;
    private $validator;

    public function __construct(ContaBancariaRepository $repository, ContaBancariaValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));
        $contasBancarias = $this->repository->all();

        return $contasBancarias;
    }

    public function getById($id)
    {
        $contaBancaria = $this->repository->find($id);

        return  $contaBancaria;
    }


    public function insert($request)
    {
        if ($this->repository->all()->last()) {
            $idContaBancaria = $this->repository->all()->last()->idContaBancaria;
        } else {
            $idContaBancaria = 0;
        }

        $contaBancaria = [
            "idContaBancaria" => $idContaBancaria + 1,
            "stContaBancaria" => $request['stContaBancaria'],
            "stBanco" => $request['stBanco'],
            "stAgencia" => $request['stAgencia'],
            "vrSaldo" => 0.00,
            "flAtivo" => true,
            "dtAlteracao" => Carbon::now(),
            "stApelido" => "",
            "flPoupanca" => false,
        ];

        $this->validator->with($contaBancaria)->passesOrFail(ValidatorInterface::RULE_CREATE);

        return $this->repository->create($contaBancaria);
    }

    public function update($data, $id)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        $data['stApelido'] = ' ';
        return $this->repository->update($data, $id);
    }

    public function delete($id)
    {
        return $this->repository->update(['flAtivo' => "0"], $id);
    }

}
