<?php

namespace App\Services\Financeiro;

use App\Entities\Financeiro\Conta;
use Carbon\Carbon;
use App\Validators\SubGrupoValidator;
use App\Entities\Financeiro\SubGrupo;
use App\Repositories\SubGrupoRepository;
use Prettus\Validator\Contracts\ValidatorInterface;

class SubGrupoService
{
    private $repository;
    private $validator;
    private $conta;


    public function __construct(SubGrupoRepository $repository ,SubGrupoValidator $validator, ContaService $conta)
    {
        $this->validator = $validator;
        $this->repository = $repository;
        $this->conta = $conta;
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));

    }

    public function get()
    {
        return SubGrupo::with('grupo','conta')->get();

    }
    public function getById($id)
    {

        $subGrupos = $this->repository->with('grupo')->find($id);

        return $subGrupos;
    }

    public function getByGroupId($id) {
        return $this->repository->findWhere(['idCategoriaConta' => $id]);
    }

    public function insert($data) {

        $subConta = [
            'idTipoConta'       => $this->nextId(),
            'idCategoriaConta'  => $data ['idCategoriaConta'],
            'stTipoConta'       => $data['stTipoConta'],
            'flEntrada'         => $data['flEntrada'],
            'idClassificacao'   => $data['idClassificacao'],
            'dtAlteracao'       => Carbon::now()
        ];
        $this->validator->with($subConta)->passesOrFail(ValidatorInterface::RULE_CREATE);

        $subGrupo = $this->repository->create($subConta);

//        Conta
        $conta = new Conta();
        $conta->idConta = $this->conta->nextId();
        $conta->idTipoConta = $subConta['idTipoConta'];
        $conta->stConta = $data['stConta'];
        $conta->dtAlteracao = Carbon::now();

        $conta->save();

        return $subGrupo;
    }

    public function update($data, $id) {

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($data, $id);
    }

    public function delete($id) {

        $hasConta = Conta::all()->where('idTipoConta', $id);
        if (!count($hasConta)) return $this->repository->delete($id);
        else return false;
    }

    public function nextId(){

        return SubGrupo::max('idTipoConta') + 1;
    }

}
