<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCliItemExtratoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cli_ItemExtrato')) {
            Schema::create('cli_ItemExtrato', function(Blueprint $table){
                $table->integer('idItem', false,true);
                $table->bigInteger('idExtrato');
                $table->bigInteger('idAbertura',false,true);
                $table->bigInteger('idProduto',false,true);
                $table->dateTime('dtData');
                $table->decimal('nrQuantidade',10, 3);
                $table->decimal('vrCusto',9, 2);
                $table->decimal('vrUnitario',9, 2);
                $table->decimal('vrDesconto',9, 2);
                $table->boolean('flAtivo');
                $table->integer('idComanda');
                $table->decimal('vrTotal',9, 2);
                $table->decimal('vrTotalCusto',9, 2);
                $table->boolean('flPago');
                $table->dateTime('dtAlteracao')->default(Carbon::now());

                $table->primary(['idItem', 'idExtrato', 'idAbertura']);

            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cli_ItemExtrato');
    }
}
