<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxVendasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_Vendas')) {
            Schema::create('cx_Vendas', function (Blueprint $table) {
                $table->integer('idVenda');
                $table->integer('idAbertura');
                $table->decimal('vrTotal', 9, 2);
                $table->boolean('flNotaFiscal');
                $table->dateTime('dtData');
                $table->integer('idCliente')->nullable(true);
                $table->decimal('vrDesconto', 9, 2);
                $table->decimal('vrAcrescimo', 9, 2);
                $table->boolean('flAtivo');
                $table->decimal('nrTempoAtendimento', 13, 0)->default(0);
                $table->integer('idOperadorAutorizador');
                $table->text('stFraseCupom');
                $table->boolean('flDelivery')->default(0);
                $table->integer('idAtendimentoDelivery')->nullable(0);
                $table->text('stContaAssinada')->nullable(true);
                $table->date('dtAlteracao')->default(\Carbon\Carbon::now());
                $table->integer('nrCOO')->default(0);
                $table->string('stCPF', 16)->nullble(true);
                $table->primary(['idVenda', 'idAbertura']);
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_Vendas');
    }
}
