<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtAtendimentosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_Atendimentos')) {

            Schema::create('mt_Atendimentos', function (Blueprint $table) {
                $table->unsignedInteger('idComanda');
                $table->dateTime('dtFirstDate');
                $table->dateTime('dtLastdate');
                $table->boolean('flReturn')->default(false);
                $table->unsignedInteger('idOperadorCaixa')->nullable();
                $table->boolean('flBloqueada')->default(false);
                $table->unsignedInteger('idMesa')->default(0);
                $table->unsignedInteger('nrPessoas')->default(1);
                $table->boolean('flConta')->default(false);
                $table->string('idMicroterminallock', 15)->default('');
                $table->string('stOperadorlock', 30)->default('');
                $table->unsignedInteger('idCliente')->nullable();
                $table->decimal('vrLimite', 9, 2)->default(0);
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->decimal('vrDesconto', 9, 2)->nullable();

                $table->primary('idComanda');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_Atendimentos');

    }
}
