<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterVwProdutosAddVrUnitario2 extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if($this->hasView()) {
            DB::statement("
                DROP VIEW [dbo].[vw_produtos]
            ");

        }

        DB::statement("
            create view [dbo].[vw_produtos] as
            select p.idProduto , REPLICATE('0', 13-LEN(C.idCodigo)) +c.idCodigo as codigo, p.stProdutoAbreviado as descricao,
            case
                when (p.flPromocao = '1' and GETDATE() BETWEEN p.dtInicioPromocao and p.dtFimPromocao) then p.vrUnitarioPromocao
                when (
                        p.flPromocaoHora = '1' and DATEPART(HOUR, GETDATE()) >= DATEPART(HOUR, p.dtInicioPromocaoHora) and DATEPART(MINUTE, GETDATE()) >= DATEPART(MINUTE, p.dtInicioPromocaoHora)
                        and DATEPART(HOUR, GETDATE()) <= DATEPART(HOUR, p.dtFimPromocaoHora) and DATEPART(MINUTE, GETDATE()) <= DATEPART(MINUTE, p.dtFimPromocaoHora)
                    )then p.vrUnitarioPromocaoHora
                    else p.vrUnitario
                end as vrUnitario,
                p.vrCusto as custo,
            CASE when m.flFracionado = '1' then 'KG'
            ELSE 'UN' end as medida,
            CASE
            when m.flFracionado = '1' then Convert(bit, '1')
            else Convert(bit, '0')
            end as kilo,
            CASE
            when p.idTipoProduto = '3' then Convert(bit, '1')
            else Convert(bit, '0')
            end as pizza,
            CASE
            when p.idTipoProduto = '2' then Convert(bit, '1')
            else Convert(bit, '0')
            end as requerValor,
            CASE
            WHEN p.nrNCM is null then '19059090'
            WHEN len(p.nrNCM) < 8  then '19059090'
            else p.nrNCM
            end as ncm,
            p.stCest as cest,
            p.flDesconto as permiteDesconto,
            p.flComissao as permiteAcrescimo,
            p.vrUnitario2 as vrUnitario2,
            a.CfopSaida as cfop,
            a.cstIcms,
            a.aliquotaIcms,
            a.cstPis,
            a.aliquotaPis,
            a.idAliquota,
            a.cstCofins,
            a.aliquotaCofins

            from prd_Codigos c

            inner join prd_Produtos  P on p.idProduto  = c.idProduto
            inner join prd_Medidas   M on m.idMedida   = p.idMedida
            left join prd_Aliquotas A on a.idAliquota = p.idAliquota
            where p.flAtivo = '1' and LEN(c.idCodigo) > 0 and LEN(p.nrNCM) >= 6
        ");

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

    private function hasView()
    {
        $response = DB::select("
            select 1 from sys.views where name= 'vw_produtos' and type='v'
        ");

        return $response;
    }
}
