<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Carbon\Carbon;

class CreatePrdRespostaProduto extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('prd_RespostaProduto')) {
            Schema::create('prd_RespostaProduto', function (Blueprint $table) {
                $table->id('idRespostaProduto');
                $table->unsignedInteger('idProduto');
                $table->decimal('vrUnitario', 9,2)->default(0);
                $table->dateTime('dtAlteracao')->default(DB::raw('GETDATE()'));
                $table->boolean('flAtivo')->default(1);
                $table->foreign('idProduto')->references('idProduto')->on('prd_Produtos');
            });
        }

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_RespostaProduto');
    }
}
