document.addEventListener("DOMContentLoaded", function () {
   masked()

    var pagina = $("#idPagina").val();
    if (pagina === "listagemProdutos") {
        $('[data-toggle="tooltip"]').tooltip();
        $('[data-toggle="popover"]').popover()
        getProdutos();
        configureModalProduto();
        initSelect2();
        $("#codigoProduto").on('tokenfield:createtoken', function (e) {
            if (e.attrs.value.length > 13 || isNaN(e.attrs.value)) {
                return false;
            }
        });

        $('#descProduto').on('keypress', function (event) {
            var regex = new RegExp("^[ a-zA-Z0-9-]+$");
            var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
            if (!regex.test(key)) {
                event.preventDefault();
                return false;
            }
        });


        $("#descProduto").bind('keyup', function (e) {
            if (e.which >= 97 && e.which <= 122) {
                var newKey = e.which - 32;
                e.keyCode = newKey;
                e.charCode = newKey;
            }
            $("#descProduto").val(($("#descProduto").val()).toUpperCase());
        });


        $('#openProduto').on('hidden.bs.modal', function () {
            $("#edit").val(0);
            $("#labelAlteracao").html('');
            $("#labelUserAlteracao").html('');
            $("#codigoProduto").tokenfield('destroy');
            $('#codigoProduto').tokenfield({
                'createTokensOnBlur': true,
                'inputType': 'text',
                'delimiter': ';'
            })
            $("#gerais :input").each(function () {
                $("#" + $(this)[0].id).val('');
                if ($(this).is(':checkbox')) {
                    $("#" + $(this)[0].id).prop('checked', false);
                }
            });

            $("#venda :input").each(function () {
                $("#" + $(this)[0].id).val('');
                if ($(this).is(':checkbox')) {
                    $("#" + $(this)[0].id).prop('checked', false);
                }
            });

            $("#icms :input").each(function () {
                $("#" + $(this)[0].id).val('');
                if ($(this).is(':checkbox')) {
                    $("#" + $(this)[0].id).prop('checked', false);
                }
            });
            $("#selectPis").val('01');
            $("#selectCofins").val('01');

            $("#nfe :input").each(function () {
                $("#" + $(this)[0].id).val('');
            });
            $("#selectClassIcms1").val('0');
            $("#selectClassIcms2").val('00');
            $("#selectTipoProduto").val('1');
            $("#selectTipoFiscal").val('10');

            $("#promocoes :input").each(function () {
                $("#" + $(this)[0].id).val('');
                if ($(this).is(':checkbox')) {
                    $("#" + $(this)[0].id).prop('checked', false);
                }
            });
            enableCheck('Promo');
            enableCheck('PromoHora');

            $("#estoque :input").each(function () {
                $("#" + $(this)[0].id).val('');
                if ($(this).is(':checkbox')) {
                    $("#" + $(this)[0].id).prop('checked', false);
                }
            });
            enableCheck('Estoque');

            $("#producao :input").each(function () {
                $("#" + $(this)[0].id).val('');
                if ($(this).is(':checkbox')) {
                    $("#" + $(this)[0].id).prop('checked', false);
                }
            });
            $("#bodyItemAdicional").html('');
            enableCheck('ItemAdicional');

            $("#nutricao :input").each(function () {
                $("#" + $(this)[0].id).val('');
                if ($(this).is(':checkbox')) {
                    $("#" + $(this)[0].id).prop('checked', false);
                }
            });
            enableCheck('Nutricional');

            $("div [id^='div']").each(function () {
                $("#" + $(this)[0].id).removeClass('has-error');
            });
            $("#divCodigoProduto").removeClass('has-success');
            $("#btnOpenProduto").html('Avançar');
        });
    } else if (pagina == "listagemProdutosInativos") {
        getProdutosInativos();
    }
});

$(document).keyup(function (e) {
    if (e.keyCode === 13) {
        var target = e.target.id;
        switch (target) {
            case 'codigoProduto':
                checkCodigo();
                $("#descProduto").focus();
                break;
            case 'descProduto':
                $("#btnOpenProduto").focus();
                break;
            case 'vrCusto' :
                $("#vrPrecoVenda").focus();
                break;
            case 'vrPrecoVenda' :
                gerarValor('margem');
                $("#vrMargemLucro").focus();
                break;
            case 'vrMargemLucro' :
                $("#btnOpenProduto").focus();
                break;
        }
    }
    var target = e.target.id;
    if (target === 'descProduto') {
        var pdrName = $("#descProduto").val();
        $("#descLen").html(50 - pdrName.length);
        if (pdrName.length < 30) {
            $("#abrProduto").val(pdrName);
            $("#descAbrLen").html(29 - pdrName.length);
        }
    }
});

$(document).ready(function () {
    $('#myTabs a').click(function (e) {
        e.preventDefault()
        if (e.currentTarget.text == 'ICMS*') {
            $("#btnOpenProduto").html('Salvar');
        }
        $(this).tab('show');
    });
});

function masked() {
    $("#nrCarboidratos").maskMoney({thousands:'', decimal:'.', affixesStay: false, allowZero: true, precision:1 });
    $("#nrFibra").maskMoney({thousands:'', decimal:'.', affixesStay: false, allowZero: true, precision:1 });
    $("#nrGorSaturada").maskMoney({thousands:'', decimal:'.', affixesStay: false, allowZero: true, precision:1 });
    $("#nrProteinas").maskMoney({thousands:'', decimal:'.', affixesStay: false, allowZero: true, precision:1 });
    $("#nrSodio").maskMoney({thousands:'', decimal:'.', affixesStay: false, allowZero: true, precision:1 });
    $("#nrGorTotais").maskMoney({thousands:'', decimal:'.', affixesStay: false, allowZero: true, precision:1 });
    $("#nrGorTrans").maskMoney({thousands:'', decimal:'.', affixesStay: false, allowZero: true, precision:1 });
}

function getProdutos() {

    $.post('produtos/resources/php/produtos_functions.php', data = {action: 'getConfig'}, function (response) {
        var count = 1;
        for (var key in response) {
            if (response[key] == 1 && key != 'idConfig') {
                count++;
            }
        }
        count = 90 / count;
        var columns = [];
        var gondulaString = "NewWindow(this.href,'printGondula','400','200','yes','center');return false";
        for (var key in response) {
            if (response[key] == 1 && key !== 'idConfig') {
                $("#" + key).prop('checked', true);
                $("#col" + key.replace('fl', '')).removeAttr('hidden');
                $("#col" + key.replace('fl', '')).css({'width': count + '%'});
                if (key == 'flVrCompra' || key === 'flVrVenda') {
                    columns.push({
                        "data": key,
                        "searchable": true,
                        "render": function (data) {
                            return 'R$ ' + data;
                        }
                    });
                } else {
                    columns.push({"data": key, "searchable": true});
                }
            }
        }
        columns.push({
            "data": "flCodigo",
            "searchable": false,
            "orderable": false,
            "render": function (data) {
                var acoes = '<a class="tdStyle" onclick="openDetalheProduto(1,' + "'" + data + "'" + ')" style="cursor:pointer"><span class="glyphicon glyphicon-search col-md-2" align="center" title="Visualizar"></span></a>';
                acoes += '<a class="tdStyle" href="produtos/printGondula.php?id=' + data + '" onclick="' + gondulaString + '" style="cursor:pointer"><span class="glyphicon glyphicon-print col-md-2" align="center" title="Imprimir"></span></a>';
                acoes += '<a class="tdStyle" onclick="editProduto(' + "'" + data + "'" + ')" style="cursor:pointer"><span class="glyphicon glyphicon-edit col-md-2" align="center" title="Editar"></span></a>';
                acoes += '<a class="tdStyle" onclick="desativarProduto(' + "'" + data + "'" + ')" style="cursor:pointer"><span class="glyphicon glyphicon-remove col-md-2" align="center" title="Desativar"></span></a>';
                return acoes;
            }
        });
        $('#listagem_produtos').DataTable({
            "bDeferRender": true,
            "processing": true,
            "serverSide": true,
            "stateSave": true,
            "columns": columns,
            "order": [[ 0, "desc" ]],
            "ajax": "produtos/resources/php/serverProdutos.php",
            "language": {
                "url": "produtos/resources/js/Portuguese-Brasil.json"
            }
        });
    });
}

function configureModalProduto() {
    $.post('produtos/resources/php/produtos_functions.php', {action: 'getConfigModulos'}, function (response) {
        for (var i = 0; i < response.length; i++) {
            if (response[i] == 'true') {
                response[i] = true;
            }
            else {
                response[i] = false;
            }
        }
        if (!response[0]) {
            $('#if-categoria').addClass('hidden');
            $('#if-subcategoria').addClass('hidden');
            $('#if-not-subcategoria').html('');
        } else {
            if (!response[1]) {
                $('#if-subcategoria').addClass('hidden');
                $('#if-cat-and-not-subcat').html('');
                $('#if-not-subcategoria').removeClass('hidden');
                $("#if-2-columns-local").addClass('col-md-pull-4');
                if (!response[2]) {
                    $("#if-2-columns-setor").addClass('col-md-pull-8');
                } else {
                    $("#if-2-columns-setor").addClass('col-md-pull-4');
                }
            } else {
                $('#if-not-subcategoria').html('');
                if (!response[2]) {
                    $("#if-2-columns-setor").addClass('col-md-pull-4');
                }
            }
        }

        if (!response[2]) {
            $('#if-local').addClass('hidden');
        }
        if (!response[3]) {
            $('#if-setor').addClass('hidden');
        }

        if (!response[4]) {
            $('#li-promocao').addClass('hidden');
        }
        if (!response[5]) {
            $('#li-estoque').addClass('hidden');
        }
        if (!response[6]) {
            $('#li-producao').addClass('hidden');
        }
        if (!response[7]) {
            $('#li-nutricao').addClass('hidden');
        }
        if (!response[8]) {
            $('#divPreco2').addClass('hidden');
        }
        if (!response[9]) {
            $('#li-nfe').addClass('hidden');
        }
        getMedida();
    });
    $.fn.modal.Constructor.prototype.enforceFocus = function () {
    };
    getSetor();
    getCategoria();
    getLocal();
    getAliquota();
    getAliquotaST();
    // getTipoSped();
    getEstoquesOrigem();
    $("#descLen").html(50);
    $("#descAbrLen").html(29);
    $('#codigoProduto').tokenfield({
        'createTokensOnBlur': true,
        'inputType': 'text',
        'delimiter': ';',
        'tokens': []
    });
    $("#dtDePromo").mask('00/00/0000');
    $("#dtAtePromo").mask('00/00/0000');
    $("#hrDePromo").mask('00:00');
    $("#hrAtePromo").mask('00:00');
    $("#hrDePromoHora").mask('00:00');
    $("#hrAtePromoHora").mask('00:00');
    $("#stCest").mask('00.000.00');
    $("#vrCusto").mask('000.000,00', {reverse: true});
    $("#vrPrecoVenda").mask('000.000,00', {reverse: true});
    $("#vrMargemLucro").mask('000.000,00', {reverse: true});
    $("#vrTabela2").mask('000.000,00', {reverse: true});
    $('#flCupomPre').prop('checked', true);
    $("#vrPrecoPromo").maskMoney({thousands:'.', decimal:',', affixesStay: false, allowZero: true});
    $("#vrPrecoPromoHora").maskMoney({thousands:'.', decimal:',', affixesStay: false, allowZero: true});

}

function openProduto() {
    $('#codigoProduto').tokenfield('destroy');
    initSelect2();
    configureModalProduto();
    var data = {action: 'getMaxCodigo'};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        $("#codigoProduto").tokenfield('createToken', response.toString());
    });
    $("#openProdutoTitle").html('Cadastro de Produto');
    $("#openProduto").modal({backdrop: 'static'});
    $('#myTabs a[href="#gerais"]').tab('show');
    $("#codigoProduto").focus();
    $("#openProduto").modal('show');
    $("#btnOpenProduto").prop("disabled",false);
    $("#btnOpenProduto").html('Avançar');
}

$('#selectItemAdicional').on("select2:close", function (e) {
    initSelect2();
});

function editProduto(codigoProduto) {
    $("#edit").val('1');
    $('.nav-tabs a[href="#gerais"]').tab('show');
    var data = {action: "getProductById", status: 1, id: String(codigoProduto)};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        if (response) {
            // SET VALORES GERAIS
            $("#labelAlteracao").html('Última alteração: ' + response.dtUltimaAlteracao);
            if (response.userLog) {
                $("#labelUserAlteracao").html('Usuário: ' + response.userLog);
            }
            $("#idProdutoModal").val(response.idProduto);
            for (var i = 0; i < response.idCodigo.length; i++) {
                response.idCodigo[i] = response.idCodigo[i].toString();
            }
            $("#codigoProduto").tokenfield('setTokens', response.idCodigo);
            $("#selectMedidaVenda").val(response.idMedidaVenda);
            $("#selectCategoria").val(response.idCategoria);
            getSubCategoriaByCategoria(response.idCategoria, response.idSubCategoria);
            $("#descProduto").val(response.stProduto);
            $("#abrProduto").val(response.stProdutoAbreviado);
            $("#descLen").html(50 - response.stProduto.length);
            $("#descAbrLen").html(29 - response.stProdutoAbreviado.length);
            $("#selectSetor").val(response.idSetor);
            $("#selectLocal").val(response.idLocalizacao);
            $("#stAdicional").val(response.stDescricao);

            $("#vrCusto").val(formataValor(response.vrCusto));
            $("#vrPrecoVenda").val(formataValor(response.vrUnitario));
            $("#vrMargemLucro").val(formataValor(response.vrMargemLucro));
            $("#vrTabela2").val(formataValor(response.vrUnitario2));

            if (response.flVendaCartao == 1) {
                $("#flCustoCartao").prop('checked', false);
            }
            else {
                $("#flCustoCartao").prop('checked', true);
            }

            if (response.flCupomPreVenda == 1) {
                $("#flCupomPre").prop('checked', false);
            }
            else {
                $("#flCupomPre").prop('checked', true);
            }

            if (response.flComissao == 1) {
                $("#flCobrarServico").prop('checked', false);
            }
            else {
                $("#flCobrarServico").prop('checked', true);
            }

            if (response.flDesconto == 1) {
                $("#flDesconto").prop('checked', false);
            }
            else {
                $("#flDesconto").prop('checked', true);
            }

            // SET VALORES ICMS/SPED
            $("#selectAliquota").val(response.idAliquota);
            $("#selectNCM").empty().append('<option id="preselectedNCM" value="'+response.nrNCM+'">'+response.nrNCM+'</option>').val(response.nrNCM).trigger('change');

            if (response.stCest != null) {
                if (response.stCest.length > 1) {
                    response.stCest = response.stCest.substr(0, 2) + '.' + response.stCest.substr(2, 3) + '.' + response.stCest.substr(5);
                    $("#stCest").val(response.stCest);
                }
            }

            // SET VALORES NFE
            $("#selectTipoProduto").val(response.idTipoProduto);
            $("#selectMedidaCompra").val(response.idMedidaCompra);

            //SET VALORES PROMOCAO
            if (response.flPromocao == 1) {
                $("#flPromo").prop('checked', true);
                dtInicioPromocao = response.dtInicioPromocao.split(' ');
                dtFimPromocao = response.dtFimPromocao.split(' ');
                $("#dtDePromo").val(dtInicioPromocao[0]);
                $("#hrDePromo").val(dtInicioPromocao[1]);
                $("#dtAtePromo").val(dtFimPromocao[0]);
                $("#hrAtePromo").val(dtFimPromocao[1]);
                $("#vrPrecoPromo").val(response.vrUnitarioPromocao);
                enableCheck('Promo');
            }
            if (response.flPromocaoHora == 1) {
                $("#flPromoHora").prop('checked', true);
                $("#hrDePromoHora").val(response.hrInicioPromocaoHora);
                $("#hrAtePromoHora").val(response.hrFimPromocaoHora);
                $("#vrPrecoPromoHora").val(response.vrUnitarioPromocaoHora);
                enableCheck('PromoHora');
            }

            //SET VALORES ESTOQUE
            if (response.flControlarEstoque === 1) {
                $("#flEstoque").prop('checked', true);
            }
                enableCheck('Estoque');
                var data2 = {action: "getSaldoEditProduto", idProduto: response.idProduto};
                $.post('produtos/resources/php/produtos_functions.php', data2, function (response2) {
                    if (response2) {
                        for (var i = 0; i < response2.length; i++) {
                            $("#flEstoqueO" + response2[i].idEstoque).prop('checked', true);
                            $("#flEstoqueO" + response2[i].idEstoque).prop('disabled', true);
                            $("#qtdEstoqueO" + response2[i].idEstoque).val(response2[i].nrQuantidade);
                            $("#qtdEstoqueO" + response2[i].idEstoque).prop('disabled', 'true');
                            $("#qtdEstoqueO" + response2[i].idEstoque).prop('title', 'Não é possível alterar a quantidade de um produto pelo cadastro do produto.');
                            $("#idSaldoO" + response2[i].idEstoque).val(response2[i].idSaldo);
                        }
                    }
                });
            // }

            //SET VALORES PRODUCAO
            if (response.flBalanca == 1) {
                $("#flBalanca").prop('checked', true);
            }
            $("#nrValidade").val(response.nrValidade);

            if (response.flRequererItemAdicional == 1) {
                $("#flItemAdicional").prop('checked', true);
                enableCheck('ItemAdicional');
                var data2 = {action: "getItemAdicionalProduto", idProduto: response.idProduto};
                $.post('produtos/resources/php/produtos_functions.php', data2, function (response2) {
                    if (response2) {
                        console.log('response2', response2)
                        for (var i = 0; i < response2.length; i++) {
                            var linha = '<tr id="rowItemAd' + response2[i].idProduto + '">';
                            linha += '<td>' + response2[i].stProduto + '</td><td>' + response2[i].nrQuantidade + " " + response2[i].stMedida + '</td><td id="vrItemAd' + response2[i].idProduto + '">R$ ' + parseFloat(response2[i].vrCustoTotal).toFixed(2) + '</td>';
                            linha += '<td><a id="btnRemoveItem' + response2[i].idProduto + '" onclick="deleteItemAdicional(' + response2[i].idProduto + ')" style="cursor:pointer"><span class="glyphicon glyphicon-remove col-md-4 col-md-offset-4" align="center" title="Remover">';
                            linha += '</span></a></td></tr>';
                            $(linha).appendTo($("#bodyItemAdicional"));
                            var vrTotal = parseFloat($("#vrTotalItemAd").text().replace('R$', ''))
                            vrTotal = parseFloat(vrTotal) + parseFloat(response2[i].vrCustoTotal);
                            vrTotal = vrTotal.toFixed(2)
                            $("#vrTotalItemAd").html('R$ ' + vrTotal);
                        }
                    }
                });
            }

            //SET VALORES NUTRICIONAIS
            if (response.flNutricional == 1) {
                $("#flNutricional").prop('checked', true);
                $("#nrValorEnergetico").val(response.nutricional.nrValorEnergetico);
                $("#nrCarboidratos").val(response.nutricional.nrCarboidratos);
                $("#nrFibra").val(response.nutricional.nrFibraAlimentar);
                $("#nrGorSaturada").val(response.nutricional.nrGordurasSaturadas);
                $("#nrProteinas").val(response.nutricional.nrProteinas);
                $("#nrSodio").val(response.nutricional.nrSodio);
                $("#nrGorTotais").val(response.nutricional.nrGordurasTotais);
                $("#nrGorTrans").val(response.nutricional.nrGordurasTrans);
                $("#nrQuantidade").val(response.nutricional.nrQuantidade);
                $("#nrUnidadePorcao").val(response.nutricional.nrUnidadePorcao);
                $("#nrParteInteiraMedidaCaseira").val(response.nutricional.nrParteInteiraMedidaCaseira);
                $("#nrParteDecimalMedidaCaseira").val(response.nutricional.nrParteDecimalMedidaCaseira);
                $("#nrMedidaCaseira").val(response.nutricional.nrMedidaCaseira);
                enableCheck('Nutricional');
            }
        }
    });
    $("#openProdutoTitle").html('Editar Produto');
    $("#btnOpenProduto").html('Salvar');
    $("#openProduto").modal({backdrop: 'static'});
    $("#openProduto").modal('show');
}

function formataValor(valor) {
    valor = parseFloat(Math.round(valor * 100) / 100).toFixed(2).toString();
    valor = valor.replace(".", ",");
    return valor;
}

function getProdutosInativos() {
    $('#listagem_produtos').DataTable({
        "bDeferRender": true,
        "processing": true,
        "serverSide": true,
        "columns": [
            {"data": "idProduto", "searchable": true},
            {"data": "stProduto", "searchable": true},
            {"data": "stCategoria", "searchable": true},
            {"data": "stMedida", "searchable": true},
            {"data": "stSetor", "searchable": true},
            {
                "data": "vrUnitario",
                "searchable": true,
                "render": function (data) {
                    return 'R$ ' + data;
                }
            },
            {"data": "stAliquota", "searchable": true},
            {
                "data": "idProduto",
                "searchable": false,
                "orderable": false,
                "render": function (data) {
                    var acoes = '<a class="tdStyle" onclick="reativarProduto(' + data + ')" style="cursor:pointer"><span class="glyphicon glyphicon-repeat col-md-4" align="center" title="Reativar"></span></a>';
                    acoes += '<a class="tdStyle" onclick="openDetalheProduto(0, ' + data + ')" style="cursor:pointer"><span class="glyphicon glyphicon-search col-md-4" align="center" title="Visualizar"></span></a>';
                    return acoes;
                }
            }
        ],
        "ajax": "produtos/resources/php/serverProdutosInativos.php",
        "language": {
            "url": "produtos/resources/js/Portuguese-Brasil.json"
        }
    });
}

function getMedida() {
    $('#selectMedidaVenda').html('');
    $('#selectMedidaCompra').html('');
    var data = {action: 'getMedidas'};
    $.post('produtos/resources/php/medidas_functions.php', data, function (response) {
        console.log('getmedida => ', response);
        for (var i = 0; i < response.length; i++) {
            $('#selectMedidaVenda').append($("<option></option>").attr("value", response[i].idMedida).text(response[i].stMedida));
            $('#selectMedidaCompra').append($("<option></option>").attr("value", response[i].idMedida).text(response[i].stMedida));
        }
    });
};

function getSetor() {
    $('#selectSetor').html('');
    var data = {action: 'getSetores'};
    $.post('produtos/resources/php/geral_functions.php', data, function (response) {
        for (var i = 0; i < response.length; i++) {
            $('#selectSetor').append($("<option></option>").attr("value", response[i].idSetor).text(response[i].stSetor));
        }
    });
};

function getCategoria() {
    $('#selectCategoria').html('');
    var data = {action: 'getCategorias'};
    $.post('produtos/resources/php/categorias_functions.php', data, function (response) {
        for (var i = 0; i < response.length; i++) {
            $('#selectCategoria').append($("<option></option>").attr("value", response[i].idCategoria).text(response[i].stCategoria));
        }
        getSubCategoriaByCategoria(response[0]['idCategoria']);
    });
};

function getSubCategoriaByCategoria(idCategoria, idSubCategoria) {
    $('#selectSubCategoria').html('');
    var data = {action: 'getSubCategoriaByCategoria', idCategoria: idCategoria};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        for (var i = 0; i < response.length; i++) {
            $('#selectSubCategoria').append($("<option></option>").attr("value", response[i].idSubCategoria).text(response[i].stSubCategoria));
        }
        if (idSubCategoria) {
            $('#selectSubCategoria').val(idSubCategoria);
        }
    });
};

function getLocal() {
    $('#selectLocal').html('');
    var data = {action: 'getLocais'};
    $.post('produtos/resources/php/geral_functions.php', data, function (response) {
        for (var i = 0; i < response.length; i++) {
            $('#selectLocal').append($("<option></option>").attr("value", response[i].idLocalizacao).text(response[i].stLocalizacao));
        }
    });
};

function getAliquota() {
    $('#selectAliquota').html('');
    var data = {action: 'getAliquota'};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        for (var i = 0; i < response.length; i++) {
            var text = response[i].stAliquota + ' - ' + response[i].Codigo + ' (' + response[i].AliquotaIcms + '%) - PIS: ' + response[i].CstPis + ' (' + response[i].AliquotaPis + '%)';
            text += ' - COFINS: ' + response[i].CstCofins + ' (' + response[i].AliquotaCofins + '%) - IVA:' + response[i].Iva + '% ';
            $('#selectAliquota').append($("<option></option>").attr("value", response[i].idAliquota).text(text));
        }
    });
};

function getAliquotaST() {
    $('#selectAliquotaST').html('');
    var data = {action: 'getAliquotaST'};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        for (var i = 0; i < response.length; i++) {
            $('#selectAliquotaST').append($("<option></option>").attr("value", response[i].idAliquota).text(response[i].stAliquota));
        }
    });
};

function getEstoquesOrigem() {
    $("#bodyEstoquesProduto").html('');
    var data = {action: 'getEstoquesOrigem'};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        if (response) {
            var linha = '';
            for (var i = 0; i < response.length; i++) {
                linha += '<tr id="rowEstoque' + response[i].idEstoque + '"><td><input id="idSaldoO' + response[i].idEstoque + '" hidden/>';
                linha += '<label class="checkbox-inline" style="cursor:pointer"><input type="checkbox" id="flEstoqueO' + response[i].idEstoque + '"/>' + response[i].stEstoque + '</label>';
                linha += '</td><td><input class="form-control input-sm" id="qtdEstoqueO' + response[i].idEstoque + '"></input></td></tr>';
            }
            $(linha).appendTo($("#bodyEstoquesProduto"));
        }
    });
}

function imprimirListagem() {

    var dataTable = $("#listagem_produtos").DataTable();
    dataTable.column($("#listagem_produtos").DataTable().columns()[0].length - 1).visible(false);
    var htmlTable = '<table class="display table table-striped table-bordered" cellspacing="0" width="100%" style="border-bottom-left-radius: 0.5em;border-bottom-right-radius: 0.5em"><caption class="table-caption"><b>Listagem de Produtos</b></caption><tbody>';
    dataTable.$('tr', {"filter": "applied"}).each(function () {
        htmlTable += this.outerHTML;
    });
    htmlTable += '</tbody></table>';
    newWin = window.open("");
    newWin.document.write('<link href="css/bootstrap.min.css" rel="stylesheet" type="text/css"/>');
    newWin.document.write(htmlTable);
    setTimeout(function () {
        newWin.print();
        dataTable.column($("#listagem_produtos").DataTable().columns()[0].length - 1).visible(true);
        newWin.close();
    }, 100);
}

function openDetalheProduto(status, id) {
    $("#statusModal").val(status);
    var data = {action: "getProductById", status: status, id: id};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        $("#stProdutoModal").html(response.stProduto);
        $("#stProdutoAbrModal").html(response.stProdutoAbreviado);
        $("#vrPrecoModal").html("R$ " + response.vrUnitario);
        $("#stMedidaModal").html(response.stMedidaVenda);
        $("#stCategoriaModal").html(response.stCategoria);
        $("#stSetorModal").html(response.stSetor);
        $("#stAliquotaModal").html(response.stAliquota);
        $("#stLocalModal").html(response.stLocalizacao);
        if (status >= 1) {
            $("#idCodigoModal").html(response.idCodigo[0] +" / "+ response.idCodigo[1]);
        } else {
            $("#idCodigoModal").html("INATIVO");
        }
        $("#dtEditadoModal").html(response.dtUltimaAlteracao);
        $("#productCode").val(response.idCodigo);
        $("#firstCode").val(response.primeiro);
        $("#previousCode").val(response.anterior);
        $("#nextCode").val(response.proximo);
        $("#lastCode").val(response.ultimo);
        $("#saldoEstoque").html(response.saldo);

    });
    $("#modalProduto").modal("show");
}

function getProdutoModal(direcao) {
    switch (direcao) {
        case 'primeiro':
            openDetalheProduto($("#statusModal").val(), $("#firstCode").val());
            break;
        case 'anterior':
            openDetalheProduto($("#statusModal").val(), $("#previousCode").val());
            break;
        case 'proximo':
            openDetalheProduto($("#statusModal").val(), $("#nextCode").val());
            break;
        case 'ultimo':
            openDetalheProduto($("#statusModal").val(), $("#lastCode").val());
            break;

    }
}

function getFornecedoresModal() {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }
    var codigoProduto = $("#productCode").val();
    var data = {action: "getFornecedoresByCodigoProduto", idCodigo: codigoProduto};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        if (response != null) {
            $("#codigoModalFornecedor").val(codigoProduto);
            for (var i = 0; i < response.length; i++) {
                var linha = '<tr><td>' + response[i].stNomeFornecedor + '</td><td>' + response[i].dtData + '</td><td>' + response[i].vrValor + '</td></tr>';
                $(linha).appendTo($("#bodyTableFornecedores"));
            }
            $("#modalProduto").modal("hide");
            $("#modalFornecedor").modal("show");
        } else {
            toastr.error("Nenhum fornecedor vinculado ao produto");
        }
    });
}

$('#modalFornecedor').on('hidden.bs.modal', function () {
    $("#bodyTableFornecedores").html("");
    openDetalheProduto($("#codigoModalFornecedor").val());
});

function desativarProduto(idCodigo) {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }

    swal({
        title: 'Tem certeza?',
        text: 'Tem certeza que deseja desativar este produto?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#2A98D3',
        cancelButtonColor: '#FF2727',
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',
        closeOnConfirm: true
    }, function() {
        $("body").addClass("loading");
        var data = {action: "desativarProduto", idCodigo: idCodigo};
        $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if (response.status) {
                toastr.success(response.msg);
                setTimeout(function () {
                    location.reload();
                }, 1000);
            } else {
                toastr.error(response.msg);
            }
        });
    });
};

function reativarProduto(idProduto) {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }

    swal({
        title: 'Tem certeza?',
        text: 'Tem certeza que deseja reativar este produto?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#2A98D3',
        cancelButtonColor: '#FF2727',
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',
        closeOnConfirm: true
    }, function () {
        $("body").addClass("loading");
        var data = {action: "reativarProduto", idProduto: idProduto};
        $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if (response.status) {
                toastr.success(response.msg);
                setTimeout(function () {
                    location.reload();
                }, 1000);
            } else {
                toastr.error(response.msg);
            }
        });
    });
};

function excluirLocal(idLocal) {
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }

    swal({
        title: 'Tem certeza?',
        text: 'Tem certeza que deseja excluir esta Categoria de Item ?',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#2A98D3',
        cancelButtonColor: '#FF2727',
        confirmButtonText: 'Continuar',
        cancelButtonText: 'Cancelar',
        closeOnConfirm: true
    }, function () {
        $("body").addClass("loading");
        var data = {action: "excluirLocal", idLocal: idLocal};
        $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
            $("body").removeClass("loading");
            if (response.status) {
                toastr.success(response.msg);
                setTimeout(function () {
                    location.reload();
                }, 1000);
            } else {
                toastr.error(response.msg);
            }
        });
    });
};

$('#modalLocal').on('hidden.bs.modal', function (e) {
    $("#divStLocal").removeClass('has-error');
    $("#stLocal").val('');
})

function enableCheck(flag) {
    switch (flag) {
        case 'Promo':
            if ($("#fl" + flag).is(":checked")) {
                $("#divPromocao").removeClass('hidden');
            } else {
                $("#divPromocao").addClass('hidden');
            }
            break;

        case 'PromoHora':
            if ($("#fl" + flag).is(":checked")) {
                $("#divPromocaoHora").removeClass('hidden');
            } else {
                $("#divPromocaoHora").addClass('hidden');
            }
            break;

        case 'Estoque':
            if ($("#fl" + flag).is(":checked")) {
                $("#divControleEstoque").removeClass('hidden');
            } else {
                $("#divControleEstoque").addClass('hidden');
            }
            break;

        case 'ItemAdicional':
            if ($("#fl" + flag).is(":checked")) {
                $("#divItemAdicional").removeClass('hidden');
            } else {
                $("#divItemAdicional").addClass('hidden');
            }
            break;

        case 'Nutricional':
            if ($("#fl" + flag).is(":checked")) {
                $("#divNutricional").removeClass('hidden');
            } else {
                $("#divNutricional").addClass('hidden');
            }
            break;
    }
};

function checkCodigo() {
    toastr.options = {"positionClass": "toast-bottom-right"};
    var codigoProduto = $("#codigoProduto").val();
    codigoProduto = codigoProduto.split(";");
    var data = {action: 'checkCodigoProduto', codigoProduto: codigoProduto}
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        if (response.status) {
            toastr.success(response.msg);
            $("#divCodigoProduto").removeClass('has-error');
            $("#divCodigoProduto").addClass('has-success');
        } else {
            toastr.error(response.msg);
            $("#divCodigoProduto").removeClass('has-success');
            $("#divCodigoProduto").addClass('has-error');
        }
    });
}

function gerarValor(tipo) {
    var custo = Number($("#vrCusto").val().replace('.', '').replace(',', '.'));
    var venda = Number($("#vrPrecoVenda").val().replace('.', '').replace(',', '.'));
    var lucro = Number($("#vrMargemLucro").val().replace('.', '').replace(',', '.'));

    switch (tipo) {
        case 'custo':
            custo = (venda / (1 + lucro / 100)).toFixed(2);
            custo = custo.replace(".", ",");
            $("#vrCusto").val(custo);
            break;
        case 'preco':
            venda = (custo + custo * lucro / 100).toFixed(2);
            venda = venda.replace(".", ",");
            $("#vrPrecoVenda").val(venda);
            break;
        case 'margem':
            lucro = (100 * venda / custo - 100).toFixed(2);
            lucro = lucro.replace(".", ",");
            $("#vrMargemLucro").val(lucro)
            break;
    }
};

function obterCest(nrNcm) {
    var nrNcm = $("#selectNCM").val();
    var data = {action: 'obterCest', nrNcm: nrNcm}

    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        response['nrCEST'] = response['nrCEST'].substr(0, 2) + '.' + response['nrCEST'].substr(2, 3) + '.' + response['nrCEST'].substr(5);
        $("#stCest").val(response['nrCEST']);
    });
}

function initSelect2() {
    $('#selectItemAdicional').select2({
        placeholder: "Digite o Código ou o Nome do Produto",
        multiple: false,
        width: '100%',
        theme: "bootstrap",
        ajax: {
            url: "estoque/resources/php/lancamento_functions.php",
            dataType: 'json',
            type: "POST",
            delay: 250,
            data: function (params) {
                return {
                    action: 'popularProduto',
                    texto: params.term, // search term
                    page: params.page
                };
            },
            processResults: function (data) {
                return {
                    results: $.map(data, function (item) {
                        return {
                            text: item.idCodigo + " - " + item.stProduto,
                            id: item.idProduto
                        }
                    })
                }
            }
        }
    });

      $('#selectNCM').select2({
          placeholder: "Digite o Código ou o Nome do NCM",
          dataType: 'jsonp',
          multiple: false,
          tags: true,
          width: '100%',
          theme: "bootstrap",
          ajax: {
              url: function(params){
                  return "api/v1/ncm/find/"+ params.term
              },
              dataType: 'json',
              type: "GET",
              delay: 250,
              data: function(params){
                  return '';
              },
              processResults: function (data) {
                  return {
                      results: $.map(data, function (item) {
                          return {
                              text: item.ncm + " - " + item.description,
                              id: item.ncm
                          }
                      })
                  }
              }
          },
          createTag: function (params) {
              params.term = params.term.replace(/\D/g,'');
              return {
                id: params.term,
                text: params.term + ' - NCM MANUAL'
            }
        }
    });
}

function addItemAdicional() {
    toastr.options = {"positionClass": "toast-bottom-right"};
    var idProduto = $("#idProdutoModal").val();
    var produto = $('#selectItemAdicional').val();
    var qtdItem = $("#qtdItemAdicional").val();
    if (produto == idProduto) {
        toastr.error('Não é possível adicionar um produto nele mesmo.');
    } else if ($("#rowItemAd" + produto)[0]) {
        toastr.error('Produto já consta na lista.');
    } else {
        console.log('produto', idProduto)
        var data = {action: 'getProductByProductId', status: 1, id: produto};
        $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
            if (response) {
                console.log('teste', response)
                if (response.flFracionado == 1) {
                    qtdItem = qtdItem / 1000;
                }
                vrItem = (response.vrCusto * qtdItem);
                data = {
                    action: 'insertItemAdicional',
                    idProdutoPrincipal: idProduto,
                    idProduto: produto,
                    qtd: qtdItem,
                    custo: vrItem
                };
                $.post('produtos/resources/php/produtos_functions.php', data, function (response2) {
                    if (response2.status) {
                        toastr.success(response2.msg);
                        var linha = '<tr id="rowItemAd' + produto + '">';
                        linha += '<td>' + response.stProduto + '</td><td>' + qtdItem + " " + response.stMedidaVenda + '</td><td id="vrItemAd' + produto + '">R$ ' + vrItem.toFixed(2) + '</td>';
                        linha += '<td><a onclick="deleteItemAdicional(' + produto + ')" style="cursor:pointer"><span class="glyphicon glyphicon-remove col-md-4 col-md-offset-4" align="center" title="Remover">';
                        linha += '</span></a></td></tr>';
                        $(linha).appendTo($("#bodyItemAdicional"));

                        var vrTotal = $("#vrTotalItemAd").text();
                        vrTotal = vrTotal.replace('R$ ', '')
                        vrTotal = parseFloat(vrTotal.replace('R$ ', ''));
                        var sum = parseFloat(vrTotal) + parseFloat(vrItem);
                        vrTotal = sum.toFixed(2);
                        $("#vrTotalItemAd").text('R$ ' + vrTotal);
                    } else {
                        toastr.error(response2.msg);
                    }
                });
            }
        });
    }
};

function deleteItemAdicional(codigoProduto) {
    toastr.options = {"positionClass": "toast-bottom-right"};
    var idProduto = $("#idProdutoModal").val();
    var data = {action: 'removeItemAdicional', idProdutoPrincipal: idProduto, idProduto: codigoProduto};
    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        if (response.status) {
            var vrItem = $("#vrItemAd" + codigoProduto).html();
            var vrTotal = $("#vrTotalItemAd").html();
            vrTotal = vrTotal.replace('R$ ', '');
            vrItem = vrItem.replace('R$ ', '');
            vrTotal = (Number(vrTotal) - Number(vrItem)).toFixed(2);
            $("#vrTotalItemAd").html('R$ ' + vrTotal);
            $("#rowItemAd" + codigoProduto).remove();
            toastr.success(response.msg);
        } else {
            toastr.error(response.msg);
        }
    });
}

function salvarProduto() {
    toastr.options = {"positionClass": "toast-bottom-right"};
    if ($("#btnOpenProduto").html() == 'Avançar') {
        var activeTab = $("ul#myTabs li.active").find('[aria-controls]').text();
        var nextTab = $("ul#myTabs li.active").next('li').find('a[data-toggle="tab"]').text();
        if (activeTab == 'ICMS*' || nextTab == 'ICMS*') {
            $("#btnOpenProduto").html('Salvar');
            $("ul#myTabs li.active").next('li').find('a[data-toggle="tab"]').tab('show');
        } else {
            $("ul#myTabs li.active").next('li').find('a[data-toggle="tab"]').tab('show');
        }
    } else {
        var edit = $("#edit").val();
        if (edit > 0) {
            var data = 'action=editarProduto&';
        } else {
            var data = 'action=cadastrarProduto&'
        }

        $("#gerais :input").each(function () {
            if ($(this).is(':checkbox')) {
                var value = 0;
                if ($(this).is(':checked')) {
                    value = 1;
                }
                data += $(this)[0].id + '=' + value + '&';
            } else {
                data += $(this)[0].id + '=' + $(this)[0].value + '&';
            }
        });
        $("#venda :input").each(function () {
            if ($(this).is(':checkbox')) {
                var value = 0;
                if ($(this).is(':checked')) {
                    value = 1;
                }
                data += $(this)[0].id + '=' + value + '&';
            } else {
                data += $(this)[0].id + '=' + $(this)[0].value + '&';
            }
        });
        $("#icms :input").each(function () {
            if ($(this).is(':checkbox')) {
                var value = 0;
                if ($(this).is(':checked')) {
                    value = 1;
                }
                data += $(this)[0].id + '=' + value + '&';
            } else {
                data += $(this)[0].id + '=' + $(this)[0].value + '&';
            }
        });
        $("#nfe :input").each(function () {
            if ($(this).is(':checkbox')) {
                var value = 0;
                if ($(this).is(':checked')) {
                    value = 1;
                }
                data += $(this)[0].id + '=' + value + '&';
            } else {
                data += $(this)[0].id + '=' + $(this)[0].value + '&';
            }
        });
        $("#promocoes :input").each(function () {
            if ($(this).is(':checkbox')) {
                var value = 0;
                if ($(this).is(':checked')) {
                    value = 1;
                }
                data += $(this)[0].id + '=' + value + '&';
            } else {
                data += $(this)[0].id + '=' + $(this)[0].value + '&';
            }
        });
        $("#nutricao :input").each(function () {
            if ($(this).is(':checkbox')) {
                var value = 0;
                if ($(this).is(':checked')) {
                    value = 1;
                }
                data += $(this)[0].id + '=' + value + '&';
            } else {
                data += $(this)[0].id + '=' + $(this)[0].value + '&';
            }
        });
        data += 'nrValidade=' + $("#nrValidade").val() + '&';
        var flBalanca = 0;
        if ($('#flBalanca').is(':checked')) {
            flBalanca = 1;
        }
        data += 'flBalanca=' + flBalanca + '&';

        var flEstoque = 0;
        if ($('#flEstoque').is(':checked')) {
            var estoquesAtivos = 'estoques=';
            var idSaldos = 'idSaldos=';
            var valoresEstoques = 'vrEstoques=';
            flEstoque = 1;
            $("#estoque [id^='flEstoqueO']").each(function () {
                if ($(this).is(":checked")) {
                    idEstoque = $(this)[0].id.replace('flEstoqueO', '');
                    idSaldo = $("#idSaldoO" + idEstoque).val();
                    vrEstoque = $("#qtdEstoqueO" + idEstoque).val();
                    if (vrEstoque == '') {
                        toastr.error('Digite uma quantidade para os estoques selecionados');
                        return false;
                    }
                    estoquesAtivos += idEstoque + '/';
                    idSaldos += idSaldo + '/';
                    valoresEstoques += vrEstoque + '/';
                }
            });
            data += 'flEstoque=' + flEstoque + '&' + estoquesAtivos + '&' + idSaldos + '&' + valoresEstoques + '&';
        } else {
            data += 'flEstoque=' + flEstoque + '&';
        }

        var flItemAdicional = 0;
        if ($('#flItemAdicional').is(':checked')) {
            flItemAdicional = 1;
        }
        data += 'flItemAdicional=' + flItemAdicional;

        var buttonSave = $("#btnOpenProduto").text();

        if(buttonSave == 'Salvar') {
            $('body').addClass('loading');
            $("#btnOpenProduto").prop("disabled",true);
        }

        $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
            if (response.status) {
                console.log('response',response);
                toastr.success(response.msg);
                setTimeout(function () {
                    location.reload();
                }, 1000);
            } else {
                $('body').removeClass('loading');
                $("#btnOpenProduto").prop("disabled", false);
                switch (response.msg) {
                    case 'DescProduto':
                        $("#div" + response.msg).addClass('has-error');
                        toastr.error('Por favor, digite uma descrição para o produto, na aba de Dados Gerais');
                        break;
                    case 'AbrProduto':
                        $("#div" + response.msg).addClass('has-error');
                        toastr.error('Por favor, digite uma abreviação para o produto, na aba de Dados Gerais');
                        break;
                    case 'VrCusto':
                        $("#div" + response.msg).addClass('has-error');
                        toastr.error('Por favor, digite um preço de custo para o produto, na aba de Venda');
                        break;
                    case 'VrPrecoVenda':
                        $("#div" + response.msg).addClass('has-error');
                        toastr.error('Por favor, digite um preço de venda para o produto, na aba de Venda');
                        break;
                    case 'CodigoProduto':
                        $("#div" + response.msg).addClass('has-error');
                        toastr.error('Por favor, digite um código válido para o produto, na aba de Dados Gerais');
                        break;
                    case 'DataDePromo' || 'DataAtePromo' || 'DataDePromoHora' || 'DataAtePromoHora':
                        $("#div" + response.msg).addClass('has-error');
                        toastr.error('Por favor, digite uma data e hora de promoção válida, na aba de Promoções');
                        break;
                    case 'VrPrecoPromo' || 'VrPrecoPromoHora':
                        $("#div" + response.msg).addClass('has-error');
                        toastr.error('Por favor, digite um valor de venda para a promoção, na aba de Promoções');
                        break;
                    case 'NCM':
                        $("#div" + response.msg).addClass('has-error');
                        toastr.error('Por favor, digite um NCM válido com no mínimo 8 caracteres, na aba ICMS');
                        break;
                    default:
                        toastr.error(response.msg);
                        break;
                }
            }
        });
    }
}

function showMenu() {
    if ($('#config-menu').val() == 0) {
        $('#config-menu').val(1);
        $('#config-menu').removeClass('no-display');
    } else {
        $('#config-menu').val(0);
        $('#config-menu').addClass('no-display');
    }
}

function saveConfig() {
    toastr.options = {"positionClass": "toast-bottom-right"};
    var data = 'action=salvarConfig&';
    $('#config-menu').find('input').each(function () {
        var value = 0
        if ($('#' + this.id).is(':checked')) {
            value = 1
        }
        data += this.id + '=' + value + '&';
    })

    $.post('produtos/resources/php/produtos_functions.php', data, function (response) {
        if (response.status) {
            toastr.success(response.msg);
            setTimeout(function () {
                location.reload();
            }, 1000);
        } else {
            toastr.error('Erro ao salvar configurações');
        }
    });
}
