<?php


namespace App\Entities\Delivery;


use App\Entities\Nati\Customer;
use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $table = 'dlv_Atendimentos';
    protected $primaryKey = "idAtendimento";
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idAtendimento',
        'idCliente',
        'idOperador',
        'dtAbertura',
        'dtConclusao',
        'stOBS',
        'stStatus',
        'flAtivo',
        'flAgendarPedido',
        'dtAgendarPedido',
        'flCupomImpresso',
        'idAbertura',
        'idVenda',
        'dtSaidaMotoboy',
        'dtChegadaMotoboy',
        'idMotoboy',
        'flOrcamento',
        'flPago',
        'flNF',
        'dtAgendarPedidoProducao',
        'nrPedido',
        'flRetornouComanda',
        'flClienteRetira',
        'cliente',
        'operador',
        'dtAlteracao',
        'reference',
        'fiscalStatus',
        'fiscalProtocolo',
        'chaveFiscal',
        'desconto',
        'cliente',
        'stCpf',
        'engine',
        'desconto'
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
        'flAgendarPedido' => 'boolean',
        'flCupomImpresso' => 'boolean',
        'flOrcamento' => 'boolean',
        'flPago' => 'boolean',
        'flNF' => 'boolean',
        'flRetornouComanda' => 'boolean',
        'flClienteRetira' => 'boolean',
    ];

    protected $appends = [
        'fullAddress',
        'phones'
    ];

    public function total()
    {
        $total = 0;
        foreach ($this->items()->get() as $item){
            $total += $item->vrTotal;
        }
        return $total;
    }

    public function payments()
    {
        return $this->hasMany(Payment::class, 'idAtendimento');
    }

    public function items()
    {
        return $this->hasMany(Item::class, 'idAtendimento');
    }

    public function customer()
    {
        return $this->hasOne(Customer::class, 'idCliente', 'idCliente');
    }

    public function getFullAddressAttribute()
    {
        return $this->customer()->join('dlv_CEPs', 'dlv_clientes.idCep', '=', 'dlv_CEPs.idCep')->first([
            'dlv_CEPs.stCEP',
            'dlv_CEPs.stEndereco',
            'dlv_CEPs.stBairro',
            'dlv_CEPs.stCidade',
            'dlv_CEPs.stEstado',
            'dlv_clientes.nrNumero',
            'dlv_clientes.stComplemento',
        ]);
    }

    public function getPhonesAttribute()
    {
        return $this->customer()->join('dlv_Telefones', 'dlv_clientes.idCliente','=','dlv_Telefones.idCliente' )->get(['nrTelefone']);
    }
}
