<?php

namespace App\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;

class Logs extends Model
{

    protected $table = 'nat_Log';
    protected $primaryKey = ['idLog'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable =[
        'idLog',
        'stOperador',
        'dtData',
        'stArea',
        'stDescricao',
        'stSoftware',
        'dtAlteracao',
    ];

    public static function writeLog($operador, $area, $log, $software = 'NATI'){
        Logs::create([
            'idLog' => Logs::getNextId(),
            'stOperador' =>$operador,
            'dtData'=>Carbon::now(),
            'stArea' =>$area,
            'stDescricao' =>$log,
            'stSoftware'=>$software,
            'dtAlteracao'=>Carbon::now(),
        ]);
    }

    public static function getNextId()
    {
        return Logs::max('idLog') + 1;
    }

}
