<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;
use Database\Factories\TaxFactory;
class Aliquota extends Model implements Transformable
{
    use TransformableTrait, HasFactory;
    protected $table = 'prd_Aliquotas';
    protected $primaryKey = 'idAliquota';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idAliquota',
        'stAliquota',
        'vrAliquota',
        'flAtivo',
        'dtAlteracao',
        'Codigo',
        'CstIcms',
        'CstPis',
        'CstCofins',
        'CfopEntrada',
        'CfopSaida',
        'Iva',
        'AliquotaIcms',
        'AliquotaCofins',
        'AliquotaPis'
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
        'Iva' => 'float',
        'AliquotaIcms' => 'float',
        'AliquotaCofins' => 'float',
        'AliquotaPis' => 'float'
    ];

    protected $appends = [
        'produtos_count'
    ];
        /**
     * Create a new factory instance for the model.
     *
     * @return \Illuminate\Database\Eloquent\Factories\Factory
     */
    protected static function newFactory()
    {
        return TaxFactory::new();
    }

    public function produtos()
    {
        return $this->hasMany(Product::class, 'idAliquota')->where('flAtivo','=' ,true);
    }

    public function getProdutosCountAttribute()
    {
        return $this->produtos()->count();
    }
}
