<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class ProdutoConfig extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = "prd_Config";
    protected $primaryKey = "idConfig";
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idConfig',
        'flDtAlteracao',
        'flCodigo',
        'flDesc',
        'flDescAbr',
        'flCategoria',
        'flSubCategoria',
        'flMedidaCompra',
        'flMedidaVenda',
        'flSetor',
        'flVrCompra',
        'flVrVenda',
        'flAliquota',
        'dtAlteracao',
        'stBalanca',
        'flNCM',
        'flIdProduto'
    ];

    protected $casts = [
        'flDtAlteracao' => 'boolean',
        'flCodigo' => 'boolean',
        'flDesc' => 'boolean',
        'flDescAbr' => 'boolean',
        'flCategoria' => 'boolean',
        'flSubCategoria' => 'boolean',
        'flMedidaCompra' => 'boolean',
        'flMedidaVenda' => 'boolean',
        'flSetor' => 'boolean',
        'flVrCompra' => 'boolean',
        'flVrVenda' => 'boolean',
        'flAliquota' => 'boolean',
        'flNCM' => 'boolean',
        'flIdProduto' => 'boolean',
    ];
}

