<?php

namespace App\Entities\Nati;

use App\Entities\Nati\SaldoEstoque;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Stock extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'est_Estoques';
    protected $primaryKey = 'idEstoque';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idEstoque',
        'stEstoque',
        'flOrigem',
        'flTipoEstoque',
        'flEntrada',
        'flAtivo',
        'flAtivarSaldo',
        'dtAlteracao',
    ];

    protected $casts = [
        'flOrigem' => 'boolean',
        'flTipoEstoque' => 'boolean',
        'flEntrada' => 'boolean',
        'flAtivo' => 'boolean',
        'flAtivarSaldo' => 'boolean',
    ];

    public function saldo() {
        return $this->hasOne(SaldoEstoque::class, 'idEstoque');
    }
}
