<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class TabelaNutricional extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'prd_TabelasNutricionais';
    protected $primaryKey = 'idTabelaNutricional';
    public $incrementing = false;
    public $timestamps = false;


    protected $fillable = [
        'idTabelaNutricional',
        'idProduto',
        'nrQuantidade',
        'nrUnidadePorcao',
        'nrParteInteiraMedidaCaseira',
        'nrParteDecimalMedidaCaseira',
        'nrMedidaCaseira',
        'nrValorEnergetico',
        'nrCarboidratos',
        'nrProteinas',
        'nrGordurasTotais',
        'nrGordurasSaturadas',
        'nrGordurasTrans',
        'nrFibraAlimentar',
        'nrSodio',
        'nrAcucaresTotais',
        'nrAcucaresAdicionados',
        'nrLactose',
        'nrGalactose',
        'stTipo',
        'nrQuantidadePorcoesEmbalagem',
        'flAltoAcucarAdicionado',
        'flAltoGorduraSaturada',
        'flAltoSodio'
    ];

}
