<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class PaymentMethod extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'cx_FormasPagamento';
    public $primaryKey = 'idFormaPagamento';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idFormaPagamento',
        'stFormaPagamento',
        'stDescricaoFiscal',
        'idTipo',
        'flTroco',
        'flVenda',
        'flSangria',
        'flGiveDifference',
        'flDespesas',
        'flSenha',
        'flAcionaGaveta',
        'stCor',
        'stAtalho',
        'flDelivery',
        'idBandeira',
        'idTEF',
        'flAtivo',
        'flfaturado',
        'stfaturado',
        'flvendabrowser',
        'dtAlteracao',
        'flImprimeRelatorio',
        'stTipo2',
        'stOperadora',
        'flAdquirente',
        'Order',
        'parentId',
        'vrTaxa',
        'pagamentoSat',
        'sync',
    ];

    protected $casts = [
        'idFormaPagamento' => 'integer',
        'flTroco' => 'boolean',
        'flVenda' => 'boolean',
        'flSangria' => 'boolean',
        'flGiveDifference' => 'boolean',
        'flDespesas' => 'boolean',
        'flSenha' => 'boolean',
        'flAcionaGaveta' => 'boolean',
        'flDelivery' => 'boolean',
        'flAtivo' => 'boolean',
        'flfaturado' => 'boolean',
        'flImprimeRelatorio' => 'boolean',
        'flvendabrowser' => 'boolean',
        'flAdquirente' => 'boolean',
        'id_type' => 'integer',
        'vrTaxa' => 'float'
    ];

    public function tipo()
    {
        return $this->hasOne(TypePaymentMethod::class, 'idTipoForma', 'idTipo');
    }
}
