<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Services\Nati\StockBalanceService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\JsonResponse;
use Illuminate\Validation\UnauthorizedException;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Http\Requests\StockBalanceCreateRequest;
use App\Http\Requests\StockBalanceUpdateRequest;

/**
 * Class StockBalancesController.
 *
 * @package namespace App\Http\Controllers;
 */
class StockBalancesController extends Controller
{
    protected $service;

    public function __construct(StockBalanceService $service)
    {
        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @return JsonResponse
     */
    public function index()
    {
        try {
            return response()->json($this->service->get());

        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 500);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param StockBalanceCreateRequest $request
     *
     * @return JsonResponse
     */
    public function store(StockBalanceCreateRequest $request)
    {
        try {
            $response = $this->service->insert($request->all());
            return response()->json($response);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        } catch (UnauthorizedException $unauthorizedException) {
            return response()->json([
                'error' => true,
                'message' => $unauthorizedException->getMessage()
            ], 403);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param int $id
     *
     * @return JsonResponse
     */
    public function show($id)
    {
        try {
            return response()->json($this->service->getById($id));

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param StockBalanceUpdateRequest $request
     * @param string                    $id
     *
     * @return JsonResponse
     */
    public function update(StockBalanceUpdateRequest $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json($response);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return JsonResponse
     */
    public function destroy($id)
    {
        try {
            $this->service->delete($id);
            return response()->json(true);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }
}
