<?php

namespace App\Repositories;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\ProductsViewRepository;
use App\Entities\ProductsView;
use App\Validators\ProductsViewValidator;

/**
 * Class ProductsViewRepositoryEloquent.
 *
 * @package namespace App\Repositories;
 */
class ProductsViewRepositoryEloquent extends BaseRepository implements ProductsViewRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return ProductsView::class;
    }

    

    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
    
}
